/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.mirage;

import cn.sylinx.hbatis.db.common.DbOper;
import cn.sylinx.hbatis.db.common.DefaultHbatisService;
import cn.sylinx.hbatis.db.common.Record;
import cn.sylinx.hbatis.db.mapper.ModelBuilder;
import cn.sylinx.hbatis.db.mapper.QueryMapper;
import cn.sylinx.hbatis.ext.common.SqlParser;
import cn.sylinx.hbatis.ext.mirage.DefaultMirageCacheQuery;
import cn.sylinx.hbatis.ext.mirage.MirageCacheQuery;
import cn.sylinx.hbatis.ext.mirage.MirageService;
import cn.sylinx.hbatis.ext.res.ClasspathSqlResource;
import cn.sylinx.hbatis.kit.Tuple;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class DefaultMirageService
extends DefaultHbatisService
implements MirageService {
    private String datasourceName;
    private final MirageCacheQuery mirageCacheQuery;
    private final Map<String, MirageService> dbServiceMap = new WeakHashMap<String, MirageService>();
    protected ReentrantLock rlock = new ReentrantLock();

    public DefaultMirageService() {
        this("hbatisDefaultJdbcResource");
    }

    public DefaultMirageService(String datasourceName) {
        super(datasourceName);
        this.datasourceName = datasourceName;
        this.mirageCacheQuery = this.createMirageCacheQuery(new Object[0]);
        this.dbServiceMap.put(datasourceName, this);
    }

    @Override
    public MirageCacheQuery withMirageCache() {
        if (this.getCacheQuery() == null || this.mirageCacheQuery == null) {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7f13\u5b58\u67e5\u8be2");
        }
        return this.mirageCacheQuery;
    }

    private MirageCacheQuery createMirageCacheQuery(Object ... params) {
        return new DefaultMirageCacheQuery(this.getCacheQuery());
    }

    @Override
    public DbOper getDbOper() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MirageService useService(String datasourceName) {
        try {
            this.rlock.lock();
            MirageService dbService = this.dbServiceMap.get(datasourceName);
            if (dbService == null) {
                dbService = this.createInstance(datasourceName);
                this.dbServiceMap.put(datasourceName, dbService);
            }
            MirageService mirageService = dbService;
            return mirageService;
        }
        finally {
            this.rlock.unlock();
        }
    }

    protected MirageService createInstance(String datasourceName) {
        return new DefaultMirageService(datasourceName);
    }

    @Override
    public String getDatasourceName() {
        return this.datasourceName;
    }

    @Override
    public <T> List<T> query(ClasspathSqlResource sqlResource, Map<String, Object> params, Class<T> clz) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        QueryMapper<T> mapper = ModelBuilder.buildQueryMapper(clz);
        return this.useService(this.datasourceName).query(st, mapper, pms);
    }

    @Override
    public List<Map<String, Object>> queryForMapList(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.useService(this.datasourceName).queryMap(st, pms);
    }

    @Override
    public List<Record> queryForRecords(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.useService(this.datasourceName).queryRecords(st, pms);
    }

    @Override
    public Record queryFirstRecord(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.useService(this.datasourceName).queryFirstRecord(st, pms);
    }

    @Override
    public List<Object[]> queryObjectArrayList(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.useService(this.datasourceName).query(st, pms);
    }

    @Override
    public Object[] queryFirstObjectArray(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.useService(this.datasourceName).queryFirst(st, pms);
    }

    @Override
    public Map<String, Object> queryFirstForMap(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.useService(this.datasourceName).queryFirstMap(st, pms);
    }

    @Override
    public <T> T queryFirst(ClasspathSqlResource sqlResource, Map<String, Object> params, Class<T> clz) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        QueryMapper<T> mapper = ModelBuilder.buildQueryMapper(clz);
        return this.useService(this.datasourceName).queryFirst(st, mapper, pms);
    }

    @Override
    public int update(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.useService(this.datasourceName).update(st, pms);
    }

    @Override
    public boolean execute(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.useService(this.datasourceName).execute(st, pms);
    }

    @Override
    public int delete(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.useService(this.datasourceName).update(st, pms);
    }

    @Override
    public Object save(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.useService(this.datasourceName).save(st, pms);
    }
}

