/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.common;

import cn.sylinx.hbatis.ext.common.TokenHandler;
import cn.sylinx.hbatis.ext.ifblock.IfEndBlockParserImpl;
import cn.sylinx.hbatis.ext.ifblock.IfEndMatcherImpl;
import cn.sylinx.hbatis.kit.Tuple;
import cn.sylinx.hbatis.log.GLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.lang.StringUtils;

public class GenericTokenParser {
    private static String TOKEN_BEGIN = "#{";
    private static String TOKEN_END = "}";
    private static String TOKEN_DY_BEGIN = "${";
    private static String TOKEN_DY_END = "}";
    private static String TOKEN_IF_BEGIN = "#IF";
    private TokenHandler handler;

    public GenericTokenParser(TokenHandler handler) {
        this.handler = handler;
    }

    protected String formatePreStatement(String preSt) {
        return preSt.replaceAll("\r", " ").replaceAll("\n", " ");
    }

    public Tuple parse(String preSt) {
        String preSt1 = this.formatePreStatement(preSt);
        String preSt2 = this.parseDynamicSql(preSt1);
        String st = this.parseDynamicPartSql(preSt2);
        ArrayList<Object> ps = new ArrayList<Object>();
        StringBuilder sb = new StringBuilder();
        this.getNextPart(st, sb, ps);
        String rst = sb.toString();
        sb.setLength(0);
        Object[] params = new Object[ps.size()];
        ps.toArray(params);
        GLog.debug("orgin sql: " + rst, new Object[0]);
        GLog.debug("orgin parameters:" + ps, new Object[0]);
        return Tuple.apply(rst, params);
    }

    protected String parseDynamicSql(String st) {
        StringBuilder sb = new StringBuilder();
        this.parseDynamicSqlNext(st, sb);
        return sb.toString();
    }

    protected String parseDynamicPartSql(String st) {
        StringBuilder sb = new StringBuilder();
        this.parseDynamicPartSqlNext(st, sb);
        return sb.toString();
    }

    private void parseDynamicPartSqlNext(String st, StringBuilder sb) {
        if (st == null) {
            throw new RuntimeException("statment is null");
        }
        int is = st.indexOf(TOKEN_DY_BEGIN);
        if (is == -1) {
            sb.append(st);
            return;
        }
        String tmp = st.substring(is);
        int ie = tmp.indexOf(TOKEN_DY_END) + is;
        if (ie == -1) {
            throw new RuntimeException("illegal statement");
        }
        String split = st.substring(is + TOKEN_DY_BEGIN.length(), ie);
        String dynamicSql = (String)this.handler.hand(split);
        String before = st.substring(0, is) + (dynamicSql == null ? "" : dynamicSql);
        sb.append(before);
        String after = st.substring(ie + TOKEN_DY_BEGIN.length() - 1);
        this.parseDynamicPartSqlNext(after, sb);
    }

    private void parseDynamicSqlNext(String st, StringBuilder sb) {
        if (st == null) {
            throw new RuntimeException("statment is null");
        }
        int is = st.indexOf(TOKEN_IF_BEGIN);
        if (is == -1) {
            sb.append(st.trim()).append(" ");
            return;
        }
        String left = st.substring(is);
        String split = this.findMatchIfEnd(left);
        int ie = is + split.length();
        boolean bl = split.startsWith("#IF[");
        if (!bl) {
            throw new RuntimeException("illegal condition statement");
        }
        String before = st.substring(0, is);
        sb.append(before.trim()).append(" ");
        IfEndBlockParserImpl block = new IfEndBlockParserImpl(this.handler);
        sb.append(block.parse(split));
        String after = st.substring(ie);
        this.parseDynamicSqlNext(after, sb);
    }

    private String findMatchIfEnd(String left) {
        IfEndMatcherImpl matcher = new IfEndMatcherImpl();
        return matcher.findMatchIfEnd(left);
    }

    private void getNextPart(String st, StringBuilder sb, List<Object> ps) {
        if (st == null) {
            throw new RuntimeException("statment is null");
        }
        int is = st.indexOf(TOKEN_BEGIN);
        if (is == -1) {
            sb.append(st);
            return;
        }
        String tmp = st.substring(is);
        int ie = tmp.indexOf(TOKEN_END) + is;
        if (ie == -1) {
            throw new RuntimeException("illegal statement");
        }
        String split = st.substring(is + TOKEN_BEGIN.length(), ie);
        ps.add(this.handler.hand(split));
        String before = st.substring(0, is) + "?";
        sb.append(before);
        String after = st.substring(ie + TOKEN_END.length());
        this.getNextPart(after, sb, ps);
    }

    public static void main(String[] args) {
        final HashMap<String, String> context = new HashMap<String, String>();
        context.put("dymsql", "and field1 = 4");
        TokenHandler th = new TokenHandler(){

            @Override
            public Object hand(String content) {
                return StringUtils.isNotBlank((String)content) ? (context == null ? null : context.get(content)) : null;
            }

            @Override
            public boolean condition(String condition) {
                try {
                    Object ret = Ognl.getValue((String)condition, (Object)context);
                    if (ret instanceof Boolean) {
                        return (Boolean)ret;
                    }
                }
                catch (OgnlException e) {
                    return false;
                }
                return false;
            }
        };
        GenericTokenParser gp = new GenericTokenParser(th);
        StringBuilder sb = new StringBuilder();
        sb.append("select count(*) from t_sys_member \n where 1=1 ${dymsql})");
        String preSql = sb.toString();
        Tuple t1 = gp.parse(preSql);
        String s1 = (String)t1.get(0);
        Object[] ps1 = (Object[])t1.get(1);
        System.out.println(s1);
        for (Object o : ps1) {
            System.out.println(o);
        }
    }
}

