/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ds;

import cn.sylinx.hbatis.ds.Resource;
import cn.sylinx.hbatis.ds.ResourceBlock;
import cn.sylinx.hbatis.exception.BlockException;
import cn.sylinx.hbatis.exception.ExecutingException;

public final class ResourceHelper {
    public static <R, O> O using(Resource<R> resourceHolder, ResourceBlock<R, O> block) {
        R resource = resourceHolder.get();
        if (resource == null) {
            throw new RuntimeException("resource is null, please check resource");
        }
        try {
            O result;
            O o = result = block.apply(resource);
            return o;
        }
        catch (BlockException e) {
            throw new ExecutingException("block.apply(resource) error: ", e);
        }
        finally {
            resourceHolder.close(resource);
        }
    }
}

