/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.db.mapper;

import cn.sylinx.hbatis.db.mapper.DeleteMapper;
import cn.sylinx.hbatis.db.mapper.InsertMapper;
import cn.sylinx.hbatis.db.mapper.QueryMapper;
import cn.sylinx.hbatis.db.mapper.UpdateMapper;
import cn.sylinx.hbatis.db.mapper.anno.PrimaryKey;
import cn.sylinx.hbatis.db.mapper.anno.Table;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.kit.Tuple;
import cn.sylinx.hbatis.log.GLog;
import cn.sylinx.hbatis.plugin.model.ModelCacheManager;
import cn.sylinx.hbatis.plugin.model.ModelFabric;
import cn.sylinx.hbatis.type.TypeHandler;
import cn.sylinx.hbatis.type.TypeHandlerRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModelBuilder {
    public static <T> Tuple buildDeleteSQL(T t, DeleteMapper<T> mapper) throws Exception {
        if (mapper == null) {
            return null;
        }
        String tableName = mapper.getTableName();
        List<String> pks = mapper.getPrimaryKeyFieldNameList();
        Map<String, String> map = mapper.getJavaToJdbcMapper();
        if (StrKit.isBlank(tableName)) {
            GLog.error("table name is empty~", new Object[0]);
            return null;
        }
        if (pks == null || pks.isEmpty()) {
            GLog.error("primary key is empty~", new Object[0]);
            return null;
        }
        if (map == null || map.isEmpty()) {
            GLog.error("java to jdbc mapper is empty~", new Object[0]);
            return null;
        }
        List<Field> fields = ModelBuilder.getObjectAllFieldsWithcache(t.getClass());
        StringBuilder sql = new StringBuilder("delete from " + tableName + " where ");
        boolean find = false;
        ArrayList<Object> params = new ArrayList<Object>();
        for (Field item : fields) {
            String fieldName = item.getName();
            if (!pks.contains(fieldName)) continue;
            String f = map.get(fieldName);
            item.setAccessible(true);
            Object v = item.get(t);
            if (f == null || v == null) continue;
            find = true;
            sql.append(f).append(" = ? ");
            params.add(v);
            break;
        }
        if (!find) {
            return null;
        }
        Object[] objects = new Object[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            objects[i] = params.get(i);
        }
        return Tuple.apply(sql.toString(), objects);
    }

    public static <T> InsertMapper<T> buildInserMapper(T t) {
        Class<?> clz = t.getClass();
        final ModelFabric mf = ModelBuilder.getModelFabric(clz);
        final String table = mf.getTableName();
        if (StrKit.isBlank(table)) {
            throw new IllegalArgumentException("\u6570\u636e\u5e93\u8868\u4e3a\u7a7a");
        }
        InsertMapper mapper = new InsertMapper<T>(){

            @Override
            public String getTableName() {
                return table;
            }

            @Override
            public Map<String, String> getJavaToJdbcMapper() {
                return mf.getAttrMapping();
            }
        };
        return mapper;
    }

    public static <T> Tuple buildInsertSQL(T t, InsertMapper<T> mapper) throws Exception {
        if (mapper == null) {
            return null;
        }
        Map<String, String> map = mapper.getJavaToJdbcMapper();
        String tableName = mapper.getTableName();
        if (map == null || map.isEmpty()) {
            GLog.error("insert mapper is empty~", new Object[0]);
            return null;
        }
        if (StrKit.isBlank(tableName)) {
            GLog.error("table name is empty~", new Object[0]);
            return null;
        }
        List<Field> fields = ModelBuilder.getObjectAllFieldsWithcache(t.getClass());
        if (fields.isEmpty()) {
            return null;
        }
        StringBuilder fds = new StringBuilder();
        StringBuilder fdsv = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        fds.append("(");
        fdsv.append("(");
        for (Field item : fields) {
            String fieldName = item.getName();
            if (!map.containsKey(fieldName)) continue;
            item.setAccessible(true);
            Object v = item.get(t);
            if (v == null || "".equals(v.toString().trim())) continue;
            String jdbcFieldName = map.get(fieldName);
            fds.append(jdbcFieldName).append(",");
            fdsv.append("?,");
            params.add(v);
        }
        if (fds.length() <= 1) {
            return null;
        }
        fds.deleteCharAt(fds.length() - 1);
        fdsv.deleteCharAt(fdsv.length() - 1);
        fds.append(")");
        fdsv.append(")");
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append(tableName).append((CharSequence)fds).append(" values ").append((CharSequence)fdsv);
        Object[] objects = new Object[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            objects[i] = params.get(i);
        }
        return Tuple.apply(sb.toString(), objects);
    }

    public static <T> Tuple buildUpdateSQL(T t, UpdateMapper<T> mapper) throws Exception {
        List<Field> fields;
        if (mapper == null) {
            return null;
        }
        Map<String, String> map = mapper.getJavaToJdbcMapper();
        List<String> pks = mapper.getPrimaryKeyFieldNameList();
        String tableName = mapper.getTableName();
        if (map == null || map.isEmpty()) {
            GLog.error("update mapper is empty~", new Object[0]);
            return null;
        }
        if (StrKit.isBlank(tableName)) {
            GLog.error("table name is empty~", new Object[0]);
            return null;
        }
        if (pks == null) {
            pks = Collections.emptyList();
        }
        if ((fields = ModelBuilder.getObjectAllFieldsWithcache(t.getClass())).isEmpty()) {
            return null;
        }
        Object id = null;
        String colunmId = null;
        StringBuilder fds = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        int count = 0;
        for (Field item : fields) {
            item.setAccessible(true);
            String fieldName = item.getName();
            if (pks.contains(fieldName)) {
                if (count > 0) {
                    GLog.error("pk multipled~", new Object[0]);
                    return null;
                }
                ++count;
                id = item.get(t);
                colunmId = map.get(fieldName);
                continue;
            }
            String f = map.get(fieldName);
            Object v = item.get(t);
            if (f == null || v == null) continue;
            fds.append(f).append(" = ?,");
            params.add(v);
        }
        if (fds.length() <= 0) {
            throw new RuntimeException("update values is empty ~");
        }
        fds.deleteCharAt(fds.length() - 1);
        StringBuilder sb = new StringBuilder();
        sb.append("update ").append(tableName).append(" set ").append((CharSequence)fds);
        if (id != null) {
            sb.append(" where ").append(colunmId).append(" = ?");
            params.add(id);
        }
        Object[] objects = new Object[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            objects[i] = params.get(i);
        }
        return Tuple.apply(sb.toString(), objects);
    }

    public static <T> T buildFirstQueryModel(ResultSet rs, QueryMapper<T> mapper) throws SQLException, InstantiationException, IllegalAccessException {
        if (mapper == null) {
            return null;
        }
        T result = null;
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] labelNames = new String[columnCount + 1];
        int[] types = new int[columnCount + 1];
        ModelBuilder.buildColumnNamesAndTypes(rsmd, labelNames, types);
        Map<String, String> maps = mapper.getJdbcToJavaMapper();
        Class<T> clz = mapper.getValueObjectClass();
        if (clz == null) {
            return null;
        }
        ModelFabric mf = ModelBuilder.getModelFabric(clz.getName());
        boolean ismapsEmpty = maps == null || maps.isEmpty();
        boolean ismappingEmpty = mf.isMappingEmpty();
        if (ismapsEmpty && ismappingEmpty) {
            if (rs.next()) {
                TypeHandler<T> th = TypeHandlerRegistry.getInstance().getTypeHandler(clz);
                T tmp1 = th.getResult(rs, 1);
                result = tmp1;
            }
        } else {
            if (ismapsEmpty) {
                maps = mf.getJdbcMapping();
            }
            Map<String, Field> fieldMap = mf.getFieldMap();
            if (rs.next()) {
                T instance = clz.newInstance();
                for (int i = 1; i <= columnCount; ++i) {
                    Field f = fieldMap.get(maps.get(labelNames[i]));
                    if (f == null) continue;
                    Class<?> cls = f.getType();
                    TypeHandler<?> th = TypeHandlerRegistry.getInstance().getTypeHandler(cls);
                    Object tmp1 = th.getResult(rs, i);
                    if (tmp1 == null) continue;
                    f.setAccessible(true);
                    f.set(instance, tmp1);
                }
                result = instance;
            }
        }
        return result;
    }

    public static <T> UpdateMapper<T> buildUpdateMapper(T t) {
        Class<?> clz = t.getClass();
        final ModelFabric mf = ModelBuilder.getModelFabric(clz);
        final String table = mf.getTableName();
        if (StrKit.isBlank(table)) {
            throw new IllegalArgumentException("\u6570\u636e\u5e93\u8868\u4e3a\u7a7a");
        }
        final PrimaryKey[] pks = mf.getPkList();
        UpdateMapper mapper = new UpdateMapper<T>(){

            @Override
            public String getTableName() {
                return table;
            }

            @Override
            public Map<String, String> getJavaToJdbcMapper() {
                return mf.getAttrMapping();
            }

            @Override
            public List<String> getPrimaryKeyFieldNameList() {
                ArrayList<String> pklist = new ArrayList<String>();
                if (pks != null && pks.length > 0) {
                    for (PrimaryKey pk : pks) {
                        if (pk == null) continue;
                        pklist.add(pk.value());
                    }
                }
                if (pklist.isEmpty()) {
                    pklist.add("id");
                }
                return pklist;
            }
        };
        return mapper;
    }

    public static <T> DeleteMapper<T> buildDeleteMapper(T t) {
        Class<?> clz = t.getClass();
        final ModelFabric mf = ModelBuilder.getModelFabric(clz);
        final String table = mf.getTableName();
        if (StrKit.isBlank(table)) {
            throw new IllegalArgumentException("\u6570\u636e\u5e93\u8868\u4e3a\u7a7a");
        }
        final PrimaryKey[] pks = mf.getPkList();
        DeleteMapper mapper = new DeleteMapper<T>(){

            @Override
            public String getTableName() {
                return table;
            }

            @Override
            public Map<String, String> getJavaToJdbcMapper() {
                return mf.getAttrMapping();
            }

            @Override
            public List<String> getPrimaryKeyFieldNameList() {
                ArrayList<String> pklist = new ArrayList<String>();
                if (pks != null && pks.length > 0) {
                    for (PrimaryKey pk : pks) {
                        if (pk == null) continue;
                        pklist.add(pk.value());
                    }
                }
                if (pklist.isEmpty()) {
                    pklist.add("id");
                }
                return pklist;
            }
        };
        return mapper;
    }

    public static <T> QueryMapper<T> buildQueryMapper(final Class<T> clz) {
        final ModelFabric mf = ModelBuilder.getModelFabric(clz);
        if (mf.isMappingEmpty()) {
            return null;
        }
        QueryMapper t = new QueryMapper<T>(){

            @Override
            public Map<String, String> getJdbcToJavaMapper() {
                return mf.getJdbcMapping();
            }

            @Override
            public Class<T> getValueObjectClass() {
                return clz;
            }
        };
        return t;
    }

    public static <T> List<T> buildQueryModel(ResultSet rs, QueryMapper<T> mapper) throws SQLException, InstantiationException, IllegalAccessException {
        ArrayList<T> result = new ArrayList<T>();
        if (mapper == null) {
            return result;
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] labelNames = new String[columnCount + 1];
        int[] types = new int[columnCount + 1];
        ModelBuilder.buildColumnNamesAndTypes(rsmd, labelNames, types);
        Map<String, String> maps = mapper.getJdbcToJavaMapper();
        Class<T> clz = mapper.getValueObjectClass();
        if (clz == null) {
            return null;
        }
        ModelFabric mf = ModelBuilder.getModelFabric(clz.getName());
        Map<String, Field> fieldMap = mf.getFieldMap();
        boolean ismapsEmpty = maps == null || maps.isEmpty();
        boolean ismappingEmpty = mf.isMappingEmpty();
        if (ismapsEmpty && ismappingEmpty) {
            while (rs.next()) {
                TypeHandler<T> th = TypeHandlerRegistry.getInstance().getTypeHandler(clz);
                T tmp1 = th.getResult(rs, 1);
                result.add(tmp1);
            }
        } else {
            if (ismapsEmpty) {
                maps = mf.getJdbcMapping();
            }
            while (rs.next()) {
                T instance = clz.newInstance();
                for (int i = 1; i <= columnCount; ++i) {
                    Field f = fieldMap.get(maps.get(labelNames[i]));
                    if (f == null) continue;
                    Class<?> cls = f.getType();
                    TypeHandler<?> th = TypeHandlerRegistry.getInstance().getTypeHandler(cls);
                    Object tmp1 = th.getResult(rs, i);
                    if (tmp1 == null) continue;
                    f.setAccessible(true);
                    f.set(instance, tmp1);
                }
                result.add(instance);
            }
        }
        return result;
    }

    private static final void buildColumnNamesAndTypes(ResultSetMetaData rsmd, String[] labelNames, int[] types) throws SQLException {
        for (int i = 1; i < labelNames.length; ++i) {
            labelNames[i] = rsmd.getColumnLabel(i);
            types[i] = rsmd.getColumnType(i);
        }
    }

    public static List<Field> getObjectAllFieldsWithcache(Class<?> cclz) {
        ModelFabric mf = ModelBuilder.getModelFabric(cclz);
        return mf.getFields();
    }

    public static Map<String, Field> getObjectAllFieldsMapWithcache(Class<?> cclz) {
        ModelFabric mf = ModelBuilder.getModelFabric(cclz);
        return mf.getFieldMap();
    }

    public static List<Field> getObjectAllFields(Class<?> cclz) {
        List<Field> fds1;
        Class<?> pclz;
        ArrayList<Field> fields = new ArrayList<Field>();
        Field[] fs = cclz.getDeclaredFields();
        if (fs != null && fs.length > 0) {
            for (Field f : fs) {
                String modifiers = Modifier.toString(f.getModifiers());
                if (modifiers.contains("final") || modifiers.contains("static")) continue;
                fields.add(f);
            }
        }
        if ((pclz = cclz.getSuperclass()) != null && !pclz.isInterface() && (fds1 = ModelBuilder.getObjectAllFields(pclz)) != null && !fds1.isEmpty()) {
            fields.addAll(fds1);
        }
        return fields;
    }

    public static Map<String, Field> getObjectAllFieldsMap(Class<?> cclz) {
        Map<String, Field> fds1;
        Class<?> pclz;
        HashMap<String, Field> fields = new HashMap<String, Field>();
        Field[] fs = cclz.getDeclaredFields();
        if (fs != null && fs.length > 0) {
            for (Field f : fs) {
                String modifiers = Modifier.toString(f.getModifiers());
                if (modifiers.contains("final") || modifiers.contains("static")) continue;
                fields.put(f.getName(), f);
            }
        }
        if ((pclz = cclz.getSuperclass()) != null && !pclz.isInterface() && (fds1 = ModelBuilder.getObjectAllFieldsMap(pclz)) != null && !fds1.isEmpty()) {
            fields.putAll(fds1);
        }
        return fields;
    }

    public static ModelFabric getModelFabric(String clzStr) {
        return ModelCacheManager.get().getModelFabric(clzStr);
    }

    public static String getModelTable(Class<?> clz) {
        Table table = clz.getAnnotation(Table.class);
        return table != null ? table.value() : null;
    }

    public static ModelFabric getModelFabric(Class<?> clz) {
        return ModelCacheManager.get().getModelFabric(clz);
    }
}

