package cn.sylinx.horm.util;

import java.util.Map;

public class ParameterHelper {

    public static boolean getBoolPrimitive(Map<String, Object> map, String key) {
        return getBoolPrimitive(map, key, false);
    }

    public static boolean getBoolPrimitive(Map<String, Object> map, String key, boolean defaultValue) {
        Boolean booleanValue = getBoolean(map, key);
        if (booleanValue == null) {
            return defaultValue;
        }
        return booleanValue;
    }

    public static Boolean getBoolean(Map<String, Object> map, String key) {
        return getObject(map, key, Boolean.class);
    }

    public static Integer getInteger(Map<String, Object> map, String key) {
        return getObject(map, key, Integer.class);
    }

    public static int getIntPrimitive(Map<String, Object> map, String key) {
        return getIntPrimitive(map, key, 0);
    }

    public static int getIntPrimitive(Map<String, Object> map, String key, int defaultValue) {
        Integer integer = getInteger(map, key);
        if (integer == null) {
            return defaultValue;
        }
        return integer;
    }

    public static Long getLong(Map<String, Object> map, String key) {
        return getObject(map, key, Long.class);
    }

    public static long getLongPrimitive(Map<String, Object> map, String key) {
        return getLongPrimitive(map, key, 0L);
    }

    public static long getLongPrimitive(Map<String, Object> map, String key, long defaultValue) {
        Long longValue = getLong(map, key);
        if (longValue == null) {
            return defaultValue;
        }
        return longValue;
    }

    public static String getString(Map<String, Object> map, String key) {
        return getObject(map, key, String.class);
    }

    public static <T> T getObject(Map<String, Object> map, String key, Class<T> clazz) {
        if (map == null) {
            return null;
        }
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        if (clazz.isInstance(value)) {
            return clazz.cast(value);
        }
        return null;
    }
}
