package cn.sylinx.horm.util;

import java.util.HashMap;
import java.util.Map;

import cn.sylinx.horm.core.common.Consts;

/**
 * 参数构建器
 * 
 * @author han
 *
 */
public class ParamMapBuilder {

    private final Map<String, Object> map = new HashMap<>();

    private ParamMapBuilder putInner(String key, Object value) {
        if (value != null) {
            map.put(key, value);
        }
        return this;
    }

    public ParamMapBuilder put(String key, Object value, Class<?> parameterType) {

        if (parameterType == null) {
            return putInner(key, value);
        }

        map.put(key, value);
        map.put(key + Consts.TYPED_PARAMETER_POSTFIX, parameterType);

        return this;
    }

    public ParamMapBuilder put(String key, Object value) {
        return putInner(key, value);
    }

    public ParamMapBuilder like(String key, String value) {
        if (StrKit.isNotBlank(value)) {
            map.put(key, "%" + value + "%");
        }
        return this;
    }

    public ParamMapBuilder likeLeft(String key, String value) {
        if (StrKit.isNotBlank(value)) {
            map.put(key, "%" + value);
        }
        return this;
    }

    public ParamMapBuilder likeRight(String key, String value) {
        if (StrKit.isNotBlank(value)) {
            map.put(key, value + "%");
        }
        return this;
    }

    public Map<String, Object> build() {
        return map;
    }

}
