package cn.sylinx.horm.util;

import java.security.MessageDigest;

import cn.sylinx.horm.exception.HORMException;

public abstract class MD5Util {

    private MD5Util() {
    }

    private static MessageDigest digest = null;

    static {
        try {
            digest = MessageDigest.getInstance("MD5");
        } catch (Exception ignored) {
        }
    }

    public static String md5(String input) {
        if (digest == null) {
            throw new HORMException("md5 instance error");
        }

        byte[] hashedBytes = digest.digest(input.getBytes());

        StringBuilder sb = new StringBuilder();
        for (byte b : hashedBytes) {
            sb.append(Integer.toString((b & 0xff) + 0x100, 16).substring(1));
        }
        return sb.toString();
    }
}
