package cn.sylinx.horm.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

/**
 * 工具类
 * 
 * @author han
 *
 */
public abstract class DbKit {

    private DbKit() {
    }

    /**
     * 关闭
     * 
     * @param aclist AutoCloseable list
     */
    public static void closeQuietly(AutoCloseable... aclist) {

        for (AutoCloseable ac : aclist) {

            if (ac != null) {
                try {
                    ac.close();
                } catch (Exception e) {
                    GLog.error("AutoCloseable close() error: ", e);
                }
            }

        }
    }

    /**
     * 关闭资源
     * 
     * @param rs ResultSet object
     * @param st Statement object
     */
    public static void closeQuietly(ResultSet rs, Statement st) {
        if (rs != null) {
            try {
                rs.close();
            } catch (SQLException e) {
                GLog.error("ResultSet close() error: ", e);
            }
        }
        if (st != null) {
            try {
                st.close();
            } catch (SQLException e) {
                GLog.error("Statement close() error: ", e);
            }
        }
    }

    /**
     * 关闭资源
     * 
     * @param st Statement object
     */
    public static void closeQuietly(Statement st) {
        if (st != null) {
            try {
                st.close();
            } catch (SQLException e) {
                GLog.error("Statement close() error: ", e);
            }
        }
    }

}
