package cn.sylinx.horm.type;

import java.util.HashMap;
import java.util.Map;

import cn.sylinx.horm.dialect.DbType;
import cn.sylinx.horm.dialect.EnumDbType;
import cn.sylinx.horm.dialect.type.TypeHandlerBuilder;
import cn.sylinx.horm.dialect.type.TypeHandlerBuilderProvider;
import cn.sylinx.horm.type.derby.DerbyTypeHandlerRegistry;

public class DefaultTypeHandlerBuilderProvider implements TypeHandlerBuilderProvider {

    @Override
    public Map<DbType, TypeHandlerBuilder> create() {
        Map<DbType, TypeHandlerBuilder> typeHanderMap = new HashMap<>(8);
        typeHanderMap.put(EnumDbType.DERBY, new DerbyTypeHandlerRegistry());
        return typeHanderMap;
    }

}
