package cn.sylinx.horm.starter;

import javax.sql.DataSource;

import cn.sylinx.horm.config.OrmConfig;
import cn.sylinx.horm.core.SqlClient;
import cn.sylinx.horm.core.datasource.NamedDataSource;
import cn.sylinx.horm.dialect.DbType;

/**
 * SqlClient 初始化器
 * 
 * @author johnhan
 *
 */
public interface SqlClientInitializor {

    SqlClient initSqlClient(NamedDataSource signleNamedDataSource, OrmConfig ormConfig);

    default SqlClient initSqlClient(NamedDataSource signleNamedDataSource) {
        return initSqlClient(signleNamedDataSource, new OrmConfig());
    }

    default SqlClient initSqlClient(DataSource dataSource, DbType dbType) {
        NamedDataSource namedDataSource = new NamedDataSource();
        namedDataSource.setDataSource(dataSource);
        namedDataSource.setDbType(dbType);
        return initSqlClient(namedDataSource);
    }
}
