package cn.sylinx.horm.resource.parse;

import cn.sylinx.horm.dialect.DbType;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.resource.ClasspathSqlResource;
import cn.sylinx.horm.resource.java.ResourceParser;
import cn.sylinx.horm.util.Pair;

import java.util.Map;

class JavaSqlParser extends SqlParser {

    // 数据库类型，用来解析不同数据库类型的sql resource
    private DbType dbtype;
    private String sqlPostfix;

    public JavaSqlParser(String sqlPostfix, DbType dbtype) {
        this.sqlPostfix = sqlPostfix;
        this.dbtype = dbtype;
    }

    public DbType getDbtype() {
        return dbtype;
    }

    public void setDbtype(DbType dbtype) {
        this.dbtype = dbtype;
    }

    public String getSqlPostfix() {
        return sqlPostfix;
    }

    public void setSqlPostfix(String sqlPostfix) {
        this.sqlPostfix = sqlPostfix;
    }

    public Pair parseSql(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        String statement = ResourceParser.parseSql(sqlResource.getSqlpath(), params);
        return PlaceholderParser.INSTANCE_DEFAULT.parseSql(statement, params);
    }

    @Override
    public String parseSqlPart(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        return ResourceParser.parseSql(sqlResource.getSqlpath(), params);
    }


    public Pair parseSql(String statement, String type, Map<String, Object> params) {
        throw new HORMException("NOT SUPPORT");
    }

    @Override
    public String parseSqlPart(String statement, String type, Map<String, Object> params) {
        throw new HORMException("NOT SUPPORT");
    }

}