package cn.sylinx.horm.resource.liquor.ext;

import java.util.Map;

public final class LiquorContextHolder {

    private final static ThreadLocal<Map<String, Object>> THREAD_LOCAL = new ThreadLocal<>();

    public static void set(Map<String, Object> context) {
        THREAD_LOCAL.set(context);
    }

    public static Map<String, Object> get() {
        return THREAD_LOCAL.get();
    }

    public static void remove() {
        THREAD_LOCAL.remove();
    }

}
