package cn.sylinx.horm.resource;

import cn.sylinx.horm.config.OrmConfigHolder;
import cn.sylinx.horm.config.ParseSqlType;
import cn.sylinx.horm.model.lambda.TypeFunction;
import cn.sylinx.horm.util.LambdaUtil;

import java.util.Map;

public class ClasspathSqlResource {

    private String sqlpath;
    private String type;

    public static ClasspathSqlResource applySystemResource(String sqlPath) {
        return apply(sqlPath, ParseSqlType.SYSTEM.getType());
    }

    public static ClasspathSqlResource applyLiquorResource(String sqlPath) {
        return apply(sqlPath, ParseSqlType.LIQUOR.getType());
    }

    public static ClasspathSqlResource applyJavaResource(String fullMethodName) {
        return apply(fullMethodName, ParseSqlType.JAVA.getType());
    }

    public static ClasspathSqlResource applyJavaResource(Class<?> className, String methodName) {
        return applyJavaResource(className.getName(), methodName);
    }

    public static ClasspathSqlResource applyJavaResource(String className, String methodName) {
        return applyJavaResource(className + "." + methodName);
    }

    public static ClasspathSqlResource applyJavaResource(TypeFunction<Map<String, Object>, String> lambda) {
        return applyJavaResource(LambdaUtil.getFullMethodName(lambda));
    }

    public static ClasspathSqlResource apply(String sqlPath) {
        return apply(sqlPath, OrmConfigHolder.getParseSqlType());
    }

    public static ClasspathSqlResource apply(String sqlPath, String type) {
        return new ClasspathSqlResource(sqlPath, type);
    }

    public ClasspathSqlResource() {
    }

    public ClasspathSqlResource(String sqlpath) {
        this(sqlpath, OrmConfigHolder.getParseSqlType());
    }

    public ClasspathSqlResource(String sqlpath, String type) {
        this.sqlpath = sqlpath;
        this.type = type;
    }

    public String getSqlResource() {
        return getSqlpath();
    }

    public String getSqlpath() {
        return sqlpath;
    }

    public void setSqlpath(String sqlpath) {
        this.sqlpath = sqlpath;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

}
