package cn.sylinx.horm.proxy.mapper.invoker;

import cn.sylinx.horm.config.OrmConfigHolder;
import cn.sylinx.horm.config.ParseSqlType;
import cn.sylinx.horm.proxy.mapper.MapperMethodMetadata;
import cn.sylinx.horm.proxy.mapper.parse.NamespaceContainer;
import cn.sylinx.horm.util.Tuple;

public abstract class AbstractMapperInvoker implements MapperInvoker {

    /**
     * 获取mapper中的信息
     *
     * @param methodMetadata
     * @return Tuple -->> [0] : Namespace, [1] : SqlItem, [2] : truelyDatasource
     */
    protected Tuple getMapper(MapperMethodMetadata methodMetadata) {

        return NamespaceContainer.getMapper(methodMetadata.getMapperInterface(), methodMetadata.getMethodName());
    }

    /**
     * 获取解析sql类型
     *
     * @param type
     * @return
     */
    protected String getParseSqlType(String type) {
        String parseSqlType = OrmConfigHolder.getParseSqlType();
        if (type != null && !parseSqlType.equals(type)) {
            if (ParseSqlType.LIQUOR.getType().equals(type)) {
                parseSqlType = ParseSqlType.LIQUOR.getType();
            } else if (ParseSqlType.SYSTEM.getType().equals(type)) {
                parseSqlType = ParseSqlType.SYSTEM.getType();
            } else if (ParseSqlType.JAVA.getType().equals(type)) {
                parseSqlType = ParseSqlType.JAVA.getType();
            }
        }
        return parseSqlType;
    }
}
