package cn.sylinx.horm.proxy.command.interceptor;

import cn.sylinx.horm.config.OrmConfigHolder;
import cn.sylinx.horm.interceptor.InterceptorManager;
import cn.sylinx.horm.interceptor.Invocation;

class CommandInterceptorManager extends InterceptorManager<CommandInterceptor> {

    static CommandInterceptorManager INSTANCE = new CommandInterceptorManager(CommandInterceptor.class);

    private CommandInterceptorManager(Class<CommandInterceptor> clazz) {
        super(clazz);
    }

    @Override
    protected CommandInterceptor getFromConfig() {
        return OrmConfigHolder.getCommandInterceptor();
    }

    @Override
    protected CommandInterceptor getDefault() {
        return Invocation::proceed;
    }
}
