package cn.sylinx.horm.pool;

import java.util.HashMap;
import java.util.Map;

import javax.sql.DataSource;

public class DefaultDataSourceSelector implements DataSourceSelector {

    private final Map<String, Object> dsMap;
    private final Map<String, Object> extConfig;

    public DefaultDataSourceSelector(Map<String, Object> dsMap, Map<String, Object> extConfig) {
        this.dsMap = new HashMap<>();
        this.dsMap.putAll(dsMap);
        this.extConfig = extConfig;
        combined();
    }

    private void combined() {
        this.dsMap.put("config", this.extConfig);
    }

    @Override
    public DataSource select(PoolType pt) {

        if (pt == null) {
            return null;
        }

        AbstractDataSourceCreator<? extends DataSource> creator = null;

        switch (pt) {
        case Beecp:
            creator = new BeeDataSourceCreator();
            break;
            
        case Druid:
            creator = new DruidDataSourceCreator();
            break;

        case TomcatJdbc:
            creator = new TomcatJdbcDataSourceCreator();
            break;

        case BoneCP:
            creator = new BoneCPDataSourceCreator();
            break;

        case C3P0:
            creator = new C3p0DataSourceCreator();
            break;

        case Dbcp2:
            creator = new Dbcp2DataSourceCreator();
            break;

        case Dbcp:
            creator = new DbcpDataSourceCreator();
            break;

        case Hikari:
            creator = new HikariDataSourceCreator();
            break;

        default:
            break;
        }

        if (creator != null) {
            return creator.create(dsMap);
        }

        return null;
    }

}
