package cn.sylinx.horm.model.cache;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import cn.sylinx.horm.model.anno.AttributeColumnMapping;
import cn.sylinx.horm.model.anno.Column;
import cn.sylinx.horm.model.anno.PrimaryKey;
import cn.sylinx.horm.model.anno.Table;
import cn.sylinx.horm.type.handler.TypeHandler;
import cn.sylinx.horm.util.StrKit;

/**
 * model结构
 * 
 * @author han
 *
 */
public class ModelFabric {

    private Table table;

    private PrimaryKey primaryKey;

    private AttributeColumnMapping mapping;

    private Map<String, Field> fieldMap;

    private List<Field> fields;

    private Map<String, Column> fieldDesc;

    private Map<String, TypeHandler<?>> typeHandlerMap;

    private Class<?> clz;

    private Map<String, String> attrMapping;

    private Map<String, String> rawAttrMapping;

    private Map<String, String> jdbcMapping;

    // 版本字段控制
    private Field versionField;

    public Field getVersionField() {
        return versionField;
    }

    public void setVersionField(Field versionField) {
        this.versionField = versionField;
    }

    public Map<String, String> getAttrMapping() {
        return attrMapping;
    }

    public Map<String, String> getJdbcMapping() {
        return jdbcMapping;
    }

    public void setJdbcMapping(Map<String, String> jdbcMapping) {
        this.jdbcMapping = jdbcMapping;
    }

    Map<String, String> createJdbcMapping() {

        Map<String, String> jdbcMapping = new HashMap<String, String>();
        if (attrMapping == null) {
            return jdbcMapping;
        }

        Set<Entry<String, String>> entrys = attrMapping.entrySet();
        for (Entry<String, String> entry : entrys) {
            jdbcMapping.put(entry.getValue(), entry.getKey());
        }
        return jdbcMapping;
    }

    public void setAttrMapping(Map<String, String> attrMapping) {
        this.attrMapping = attrMapping;
    }

    public List<Field> getFields() {
        return fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public Table getTable() {
        return table;
    }

    public String getTableName() {
        if (table == null) {

            if (clz == null) {
                return null;
            }

            // 默认使用模型作为表名（驼峰转下划线）
            return StrKit.enCodeUnderlined(clz.getSimpleName());
        }

        return table.value();
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public PrimaryKey getPrimaryKey() {
        return primaryKey;
    }

    public void setPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public AttributeColumnMapping getMapping() {
        return mapping;
    }

    public void setMapping(AttributeColumnMapping mapping) {
        this.mapping = mapping;
    }

    public Map<String, Field> getFieldMap() {
        return fieldMap;
    }

    public void setFieldMap(Map<String, Field> fieldMap) {
        this.fieldMap = fieldMap;
    }

    public Class<?> getClz() {
        return clz;
    }

    public void setClz(Class<?> clz) {
        this.clz = clz;
    }

    public void clear() {

        table = null;
        primaryKey = null;
        mapping = null;

        if (fieldMap != null) {
            fieldMap.clear();
            fieldMap = null;
        }

        if (fields != null) {
            fields.clear();
            fields = null;
        }

        if (attrMapping != null) {
            attrMapping.clear();
            attrMapping = null;
        }

        clz = null;
    }

    public Map<String, Column> getFieldDesc() {
        return fieldDesc;
    }

    public void setFieldDesc(Map<String, Column> fieldDesc) {
        this.fieldDesc = fieldDesc;
    }

    public boolean isMappingEmpty() {

        return attrMapping == null || attrMapping.isEmpty();
    }

    public Map<String, String> getRawAttrMapping() {
        return rawAttrMapping;
    }

    public void setRawAttrMapping(Map<String, String> rawAttrMapping) {
        this.rawAttrMapping = rawAttrMapping;
    }

    public Map<String, TypeHandler<?>> getTypeHandlerMap() {
        return typeHandlerMap;
    }

    public void setTypeHandlerMap(Map<String, TypeHandler<?>> typeHandlerMap) {
        this.typeHandlerMap = typeHandlerMap;
    }

}
