package cn.sylinx.horm.dialect.fs.builder;

import cn.sylinx.horm.dialect.fs.FS;

class SqliteFSBuilder implements FSBuilder {

    @Override
    public <T> FS<T> build(Class<T> modelClass) {
        return SqliteFS.of(modelClass);
    }

    @Override
    public <T> FS<T> build(Class<T> modelClass, String tablePostfix) {
        return SqliteFS.of(modelClass, tablePostfix);
    }

    @Override
    public <T> FS<T> build(String tablePrefix, Class<T> modelClass) {
        return SqliteFS.of(tablePrefix, modelClass);
    }

    @Override
    public <T> FS<T> build(String tablePrefix, Class<T> modelClass, String tablePostfix) {
        return SqliteFS.of(tablePrefix, modelClass, tablePostfix);
    }

}
