package cn.sylinx.horm.dialect.fs.builder;

import cn.sylinx.horm.dialect.fs.FS;
import cn.sylinx.horm.model.cache.ModelCacheUtil;

class OracleFS<T> extends FS<T> {

    public static <T> FS<T> of(Class<T> modelClass) {
        return new OracleFS<T>().init(modelClass);
    }

    public static <T> FS<T> of(Class<T> modelClass, String tablePostfix) {
        return new OracleFS<T>().init(modelClass, tablePostfix);
    }

    public static <T> FS<T> of(String tablePrefix, Class<T> modelClass) {
        return new OracleFS<T>().init(tablePrefix, modelClass);
    }

    public static <T> FS<T> of(String tablePrefix, Class<T> modelClass, String tablePostfix) {
        return new OracleFS<T>().init(tablePrefix, modelClass, tablePostfix);
    }

    protected String getDefaultTableName() {
        return preEscape + tablePrefix + ModelCacheUtil.getModelFabric(modelClass).getTableName().toUpperCase()
                + tablePostfix + postEscape;
    }

    @Override
    protected String[] getEscape() {
        return new String[] { "\"", "\"" };
    }

    public String mapColumn(String column) {
        String trueColumn = attrs.get(column);
        return preEscape + (trueColumn == null ? column : trueColumn).toUpperCase() + postEscape;
    }
}
