package cn.sylinx.horm.dialect.fs.builder;

import cn.sylinx.horm.dialect.fs.FS;

class DuckdbFSBuilder implements FSBuilder {

    @Override
    public <T> FS<T> build(Class<T> modelClass) {
        return DuckdbFS.of(modelClass);
    }

    @Override
    public <T> FS<T> build(Class<T> modelClass, String tablePostfix) {
        return DuckdbFS.of(modelClass, tablePostfix);
    }

    @Override
    public <T> FS<T> build(String tablePrefix, Class<T> modelClass) {
        return DuckdbFS.of(tablePrefix, modelClass);
    }

    @Override
    public <T> FS<T> build(String tablePrefix, Class<T> modelClass, String tablePostfix) {
        return DuckdbFS.of(tablePrefix, modelClass, tablePostfix);
    }

}
