package cn.sylinx.horm.dialect;

import cn.sylinx.horm.dialect.impl.*;
import cn.sylinx.horm.dialect.spi.DialectSPIManager;

public enum DialectFactory {
    ;

    public static Dialect createDialect(DbType dbType) {

        switch (dbType.getValue()) {
            case DbConstant.mysql:
                return new MySqlDialect();
            case DbConstant.oracle:
                return new OracleDialect();
            case DbConstant.sqlserver:
                return new SqlServerDialect();
            case DbConstant.derby:
                return new DerbyDialect();
            case DbConstant.postgresql:
                return new PostgreSQLDialect();
            case DbConstant.db2:
                return new Db2Dialect();
            case DbConstant.h2:
                return new H2Dialect();
            case DbConstant.clickhouse:
                return new ClickHouseDialect();
            case DbConstant.sqlite:
                return new SqliteDialect();
            case DbConstant.hsqldb:
                return new HsqldbDialect();
            case DbConstant.duckdb:
                return new DuckdbDialect();
            default:
                return createDialectBySPI(dbType.getValue());
        }
    }

    private static Dialect createDialectBySPI(String dbType) {
        return DialectSPIManager.createDialectBySPI(dbType);
    }

    public static Dialect createDialect(String dbTypeName) {
        return createDialect(DbType.getDbType(dbTypeName));
    }
}