package cn.sylinx.horm.core.datasource;

import cn.sylinx.horm.exception.TransactionException;

/**
 * 带事务的连接提供者
 * 
 * @author johnhan
 *
 */
public interface TransactionalConnectionProvider extends ConnectionProvider {
    public void startTransaction();

    public void startTransaction(int isolationLevel);

    public boolean isInTransaction();

    public void commitTransaction() throws TransactionException;

    public void rollbackTransaction();
}