package cn.sylinx.horm.util;

import cn.sylinx.horm.exception.HORMException;

public class Pair extends Tuple {

    public static Pair of(Object first, Object second) {
        return new Pair(first, second);
    }

    public static Pair apply(Object first, Object second) {
        return of(first, second);
    }

    public Pair(Object first, Object second) {
        super(new Object[] { first, second });
    }

    public <T> T getFirst() {
        return getObject(0);
    }

    public <T> T getSecond() {
        return getObject(1);
    }

    @Override
    public void setItems(Object[] items) {

        if (items == null || items.length != 2) {
            throw new HORMException("invalid pair");
        }

        super.setItems(items);
    }

}
