package cn.sylinx.horm.resource.parse;

import java.util.List;

/**
 * if-elsif-else-end 结构描述
 * 
 * @author johnhan
 *
 */
public class IfElseBlockNode implements ParsedNode {

    private IFConditionBlock ifConditionBlock;

    private List<ELSIFConditionBlock> elsifConditionBlock;

    private ELSEConditionBlock elseConditionBlock;

    private ENDConditionBlock endConditionBlock;

    public IFConditionBlock getIfConditionBlock() {
        return ifConditionBlock;
    }

    public void setIfConditionBlock(IFConditionBlock ifConditionBlock) {
        this.ifConditionBlock = ifConditionBlock;
    }

    public List<ELSIFConditionBlock> getElsifConditionBlock() {
        return elsifConditionBlock;
    }

    public void setElsifConditionBlock(List<ELSIFConditionBlock> elsifConditionBlock) {
        this.elsifConditionBlock = elsifConditionBlock;
    }

    public ELSEConditionBlock getElseConditionBlock() {
        return elseConditionBlock;
    }

    public void setElseConditionBlock(ELSEConditionBlock elseConditionBlock) {
        this.elseConditionBlock = elseConditionBlock;
    }

    public ENDConditionBlock getEndConditionBlock() {
        return endConditionBlock;
    }

    public void setEndConditionBlock(ENDConditionBlock endConditionBlock) {
        this.endConditionBlock = endConditionBlock;
    }

    @Override
    public int getStartIndex() {
        return ifConditionBlock.getIfToken().getStartIndex();
    }

    @Override
    public int getEndIndex() {
        return endConditionBlock.getEndToken().getEndIndex();
    }

    @Override
    public String toString() {
        return "IfElseBlockNode [ifConditionBlock=" + ifConditionBlock + ", elsifConditionBlock=" + elsifConditionBlock
                + ", elseConditionBlock=" + elseConditionBlock + ", endConditionBlock=" + endConditionBlock + "]";
    }

}
