package cn.sylinx.horm.resource.lexer;

import cn.sylinx.horm.exception.HORMException;

import java.util.HashSet;

public abstract class Keyword {

    private Keyword() {

    }

    public static final String KW_IF = "#IF";
    public static final String KW_ELSIF = "#ELSIF";
    public static final String KW_ELSE = "#ELSE";
    public static final String KW_END = "#END";
    public static final String KW_FUNC = "#FUNC";
    public static final String KW_INC = "#INC";

    private static final HashSet<String> KEYWORDS = new HashSet<String>();
    private static final HashSet<String> KEYWORDS_NEED_SQUARE_BRACKET_CONTENT = new HashSet<String>();

    static {
        KEYWORDS.add(Keyword.KW_IF);
        KEYWORDS.add(Keyword.KW_ELSIF);
        KEYWORDS.add(Keyword.KW_ELSE);
        KEYWORDS.add(Keyword.KW_END);
        KEYWORDS.add(Keyword.KW_FUNC);
        KEYWORDS.add(Keyword.KW_INC);

        KEYWORDS_NEED_SQUARE_BRACKET_CONTENT.add(Keyword.KW_IF);
        KEYWORDS_NEED_SQUARE_BRACKET_CONTENT.add(Keyword.KW_ELSIF);
        KEYWORDS_NEED_SQUARE_BRACKET_CONTENT.add(Keyword.KW_FUNC);
        KEYWORDS_NEED_SQUARE_BRACKET_CONTENT.add(Keyword.KW_INC);
    }

    /**
     * 中括号内需要有内容
     * 
     * @param key
     * @return
     */
    static boolean needSquareBracketContent(String key) {
        return KEYWORDS_NEED_SQUARE_BRACKET_CONTENT.contains(key);
    }

    static boolean hitKeyword(String key) {
        return KEYWORDS.contains(key);
    }

    static boolean isSeeminglyKeyword(String kw) {

        if (KW_IF.startsWith(kw) || KW_ELSIF.startsWith(kw) || KW_ELSE.startsWith(kw) || KW_END.startsWith(kw)
                || KW_FUNC.startsWith(kw) || KW_INC.startsWith(kw)) {
            return true;
        }

        return false;
    }

    public static KeywordToken create(String keyword, int lineNo, int startIndex, int endIndex) {

        if (KW_IF.equals(keyword)) {
            return new IFToken(lineNo, startIndex, endIndex);
        }

        if (KW_ELSIF.equals(keyword)) {
            return new ELSIFToken(lineNo, startIndex, endIndex);
        }

        if (KW_ELSE.equals(keyword)) {
            return new ELSEToken(lineNo, startIndex, endIndex);
        }

        if (KW_END.equals(keyword)) {
            return new ENDToken(lineNo, startIndex, endIndex);
        }

        if (KW_FUNC.equals(keyword)) {
            return new FUNCToken(lineNo, startIndex, endIndex);
        }

        if (KW_INC.equals(keyword)) {
            return new INCToken(lineNo, startIndex, endIndex);
        }

        throw new HORMException("invalid keyword: " + keyword);
    }
}
