
package cn.sylinx.horm.model.strategy;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import cn.sylinx.horm.model.anno.Column;
import cn.sylinx.horm.model.cache.ModelFabric;
import cn.sylinx.horm.util.StrKit;

/**
 * 和属性一致策略
 * 
 * @author han
 *
 */
public class AttributeStrategy implements Strategy {

    @Override
    public Map<String, String> createAttrMapping(ModelFabric mf) {
        return createRawAttrMapping(mf);
    }

    @Override
    public Map<String, String> createRawAttrMapping(ModelFabric mf) {

        Map<String, Column> fieldDescMap = mf.getFieldDesc();
        Map<String, String> attrMapping = new HashMap<String, String>();

        Set<String> attrs = mf.getFieldMap().keySet();
        for (String attr : attrs) {

            String column = attr;
            Column cd = fieldDescMap.get(attr);
            if (cd != null && StrKit.isNotBlank(cd.column())) {
                // 数据库字段不为空
                column = cd.column();
            }
            attrMapping.put(attr, column);
        }

        return attrMapping;
    }

}
