
package cn.sylinx.horm.model.cache;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

import cn.sylinx.horm.model.strategy.Strategy;
import cn.sylinx.horm.util.GLog;

public enum ModelConst {

    ME;

    /**
     * 全局模型字段映射策略
     */
    private static final String KEY_MAPPING_STRATEGY = "MAPPING_STRATEGY";

    final Map<String, Object> params = new HashMap<>();

    public Object getConst(String key) {
        return params.get(key);
    }

    /**
     * 获取全局模型字段映射策略
     * 
     * @return
     */
    public Strategy getMappingStrategy() {
        return (Strategy) params.get(KEY_MAPPING_STRATEGY);
    }

    public void setMappingStrategy(String mappingStrategy) {

        Strategy mappingStrategyEntity = getMappingStrategy();

        if (mappingStrategyEntity != null) {
            GLog.error("参数MAPPING_STRATEGY只能被设置一次");
            return;
        }

        try {
            Class<?> strategyClz = Class.forName(mappingStrategy);
            Object inst = strategyClz.getDeclaredConstructor().newInstance();
            if (inst instanceof Strategy) {
                GLog.info("全局模型字段映射策略{}已加载", mappingStrategy);
                params.put(KEY_MAPPING_STRATEGY, inst);
            }

        } catch (ClassNotFoundException | InstantiationException | IllegalAccessException | IllegalArgumentException
                | InvocationTargetException | NoSuchMethodException | SecurityException e) {
            GLog.error("异常:", e);
        }

    }

}
