package cn.sylinx.horm.dialect.sql;

import java.util.HashMap;
import java.util.Map;

import cn.sylinx.horm.dialect.DbType;
import cn.sylinx.horm.dialect.EnumDbType;

public class SqlBuilderFactory {

    private final Map<DbType, SqlBuilder> registers = new HashMap<DbType, SqlBuilder>();

    private static final SqlBuilderFactory instance = new SqlBuilderFactory();

    private final DefaultSqlBuilder defaultSqlBuilder = new DefaultSqlBuilder();

    public static SqlBuilderFactory get() {
        return instance;
    }

    private SqlBuilderFactory() {
        registerDefault();
    }

    /**
     * 注册 SqlBuilder
     */
    private void registerDefault() {

        register(EnumDbType.MYSQL, new MySqlSqlBuilder());
        register(EnumDbType.ORACLE, new OracleSqlBuilder());
        register(EnumDbType.SQLSERVER, new SqlServerSqlBuilder());
        register(EnumDbType.DERBY, new DerbySqlBuilder());
        register(EnumDbType.DB2, new DB2SqlBuilder());
        register(EnumDbType.POSTGRESQL, new PostgreSQLSqlBuilder());
        register(EnumDbType.DUCKDB, new DuckdbSqlBuilder());
        register(EnumDbType.H2, new H2SqlBuilder());
        register(EnumDbType.CLICKHOUSE, new ClickHouseSqlBuilder());
        register(EnumDbType.SQLITE, new SqliteSqlBuilder());
        register(EnumDbType.HSQLDB, new HsqldbSqlBuilder());
    }

    public void register(DbType dbType, SqlBuilder sqlBuilder) {
        registers.put(dbType, sqlBuilder);
    }

    public SqlBuilder getSqlBuilder(DbType dbType) {
        SqlBuilder sb = registers.get(dbType);
        if (sb == null) {
            return defaultSqlBuilder;
        }
        return sb;
    }
}
