package cn.sylinx.horm.dialect.sql;

import cn.sylinx.horm.util.Tuple;

class DuckdbSqlBuilder extends DefaultSqlBuilder {

    @Override
    protected String[] getEscapeChar() {
        return new String[] { "\"", "\"" };
    }

    @Override
    public Tuple buildPaginatorSql(String preSql, int pageNumber, int pageSize) {

        String sqlCount = "select count(1) as totalCount from (" + preSql + ") as temp";
        String sql = preSql + " limit ? offset ? ";
        int offset = pageSize * (pageNumber - 1);
        Object[] params = new Object[] { pageSize, offset };
        return Tuple.apply(sqlCount, sql, params);
    }
}
