package cn.sylinx.horm.core.stat;

import cn.sylinx.horm.config.OrmConfigHolder;

/**
 * SQL运行时长事件辅助类
 *
 * @author johnhan
 */
public interface SqlStatEventHelper {

    static boolean isSqlStatNotEnable() {
        return !OrmConfigHolder.isSqlStatOpen();
    }

    static void sendSqlStatBefore(String seq, String datasourceName, String nativeSql, long time) {

        if (isSqlStatNotEnable()) {
            // sql监控未启动
            return;
        }

        SqlStatManager.receiveSql(SqlStatInfo.SQL_TYPE_BEFORE, seq, datasourceName, nativeSql, time, null);
    }

    static void sendSqlStatAfter(String seq, String datasourceName, String nativeSql, long usedTime,
                                 Throwable error) {

        if (isSqlStatNotEnable()) {
            // sql监控未启动
            return;
        }

        SqlStatManager.receiveSql(SqlStatInfo.SQL_TYPE_AFTER, seq, datasourceName, nativeSql, usedTime, error);

    }
}
