package cn.sylinx.horm.core;

import java.io.Serializable;
import java.util.List;

import cn.sylinx.horm.core.common.Page;
import cn.sylinx.horm.core.common.Record;
import cn.sylinx.horm.dialect.fs.FS;
import cn.sylinx.horm.dialect.fs.PlainFS;

public interface FluentSqlClient extends Closeable {

    <T> List<T> query(FS<T> fluentSql);

    <T, R> List<R> queryForSingleColumn(FS<T> fluentSql);

    <T> T queryFirst(FS<T> fluentSql);

    <T, R> R queryFirstForSingleColumn(FS<T> fluentSql);

    int update(FS<?> fluentSql);

    int delete(FS<?> fluentSql);

    int count(FS<?> fluentSql);

    Serializable insert(FS<?> fluentSql);

    <T> Page<T> queryPage(FS<T> fluentSql, int pageNumber, int pageSize);

    List<Record> query(PlainFS fluentSql);

    Record queryFirst(PlainFS fluentSql);

    int update(PlainFS fluentSql);

    int delete(PlainFS fluentSql);

    int count(PlainFS fluentSql);

    Serializable insert(PlainFS fluentSql);

    Page<Record> queryPage(PlainFS fluentSql, int pageNumber, int pageSize);

}