package cn.sylinx.horm.config.specific;

import cn.sylinx.horm.util.GLog;

public class SpecificConfig implements Cloneable {

    public static final String DS_CONFIG_KEYWORD = "specific-config";

    // 是否开启SQL统计
    private Boolean sqlStatOpen;
    // 当前数据源是否支持代理
    private Boolean sqlClientInterceptorEnable;

    public Boolean getSqlStatOpen() {
        return sqlStatOpen;
    }

    public void setSqlStatOpen(Boolean sqlStatOpen) {
        this.sqlStatOpen = sqlStatOpen;
    }

    public boolean isSqlStatOpen() {
        return sqlStatOpen != null && sqlStatOpen;
    }

    public Boolean getSqlClientInterceptorEnable() {
        return sqlClientInterceptorEnable;
    }

    public void setSqlClientInterceptorEnable(Boolean sqlClientInterceptorEnable) {
        this.sqlClientInterceptorEnable = sqlClientInterceptorEnable;
    }

    public boolean isSqlClientInterceptorEnable() {
        return sqlClientInterceptorEnable != null && sqlClientInterceptorEnable;
    }

    @Override
    public Object clone() {
        SpecificConfig clone = null;
        try {
            clone = (SpecificConfig) super.clone();
        } catch (CloneNotSupportedException e) {
            GLog.error("clone error", e);
            return createCloneObject();
        }
        return clone;
    }

    private Object createCloneObject() {
        SpecificConfig c = new SpecificConfig();
        c.setSqlStatOpen(sqlStatOpen);
        c.setSqlClientInterceptorEnable(sqlClientInterceptorEnable);
        return c;
    }

    @Override
    public String toString() {
        return "SpecificConfig [sqlStatOpen=" + sqlStatOpen + ", sqlClientInterceptorEnable="
                + sqlClientInterceptorEnable + "]";
    }
}
