package cn.sylinx.horm.config;

public enum ParseSqlType {

    SYSTEM("system"), // 默认系统

    LIQUOR("liquor"); // 使用liquor（基于java）解析

    private final String type;

    ParseSqlType(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }

    public static ParseSqlType getByType(String type) {
        ParseSqlType[] vs = ParseSqlType.values();
        for (ParseSqlType v : vs) {
            if (v.type.equals(type)) {
                return v;
            }
        }
        return null;
    }

}
