package cn.sylinx.horm.config;

import cn.sylinx.horm.proxy.command.interceptor.CommandInterceptor;
import cn.sylinx.horm.util.ClassUtil;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.StrKit;

class CommandInterceptorLoader {

    private final OrmConfig ormConfig;

    CommandInterceptorLoader(OrmConfig ormConfig) {
        this.ormConfig = ormConfig;
    }

    public CommandInterceptor load() {

        String commandInterceptorClass = ormConfig.getCommandInterceptorClass();
        if (StrKit.isNotBlank(commandInterceptorClass)) {
            try {
                Class<?> clz = Class.forName(commandInterceptorClass, false, ClassUtil.getDefaultClassLoader());
                GLog.info("load command interceptor: {}", commandInterceptorClass);
                return (CommandInterceptor) clz.newInstance();
            } catch (Exception e) {
                GLog.error("command command interceptor load error", e);
            }
        }
        GLog.info("NO Command Interceptor loaded");
        return null;
    }
}
