/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.util;

import java.util.Arrays;

public class Tuple {
    private Object[] items;

    public static Tuple apply(Object ... args) {
        return new Tuple(args);
    }

    public Tuple(Object[] items) {
        this.items = items;
    }

    public Tuple() {
    }

    public Object[] getItems() {
        return this.items;
    }

    public void setItems(Object[] items) {
        this.items = items;
    }

    public Object get(int index) {
        if (index < 0 || this.items == null || index > this.items.length - 1) {
            return null;
        }
        return this.items[index];
    }

    public <T> T getObject(int index) {
        Object obj = this.get(index);
        return (T)obj;
    }

    public <T> T getObject(int index, Class<T> clz) {
        Object obj = this.get(index);
        return (T)obj;
    }

    public int length() {
        return this.items == null ? 0 : this.items.length;
    }

    public String toString() {
        return "Tuple [items=" + this.toStringExt() + "]";
    }

    private String toStringExt() {
        if (this.items == null) {
            return "null";
        }
        int iMax = this.items.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            if (this.items[i] == null) {
                b.append("null");
            } else if (this.items[i].getClass().isArray()) {
                b.append(Arrays.toString((Object[])this.items[i]));
            } else {
                b.append(String.valueOf(this.items[i]));
            }
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }
}

