/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.util;

import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.util.GLog;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class LambdaUtil {
    private static final Map<Class<?>, SerializedLambda> LAMBDA_CACHE = new WeakHashMap();

    private LambdaUtil() {
    }

    public static String methodToFieldName(String methodName) {
        if (!methodName.startsWith("get")) {
            throw new HORMException("invalid get method");
        }
        return LambdaUtil.capitalize(methodName.replaceFirst("get", ""));
    }

    public static String capitalize(String input) {
        return input.substring(0, 1).toLowerCase() + input.substring(1);
    }

    public static String getLambdaFieldName(Serializable lambda) {
        SerializedLambda serializedLambda = LambdaUtil.computeSerializedLambda(lambda);
        if (serializedLambda == null) {
            throw new HORMException("\u83b7\u53d6\u5b9e\u4f53\u5217\u540d\u5f02\u5e38");
        }
        return LambdaUtil.methodToFieldName(serializedLambda.getImplMethodName());
    }

    private static SerializedLambda computeSerializedLambda(Serializable lambda) {
        Class<?> cl = lambda.getClass();
        SerializedLambda cacheLambda = LAMBDA_CACHE.get(cl);
        if (cacheLambda != null) {
            GLog.debug("SerializedLambda bingo, class:{}", cl);
            return cacheLambda;
        }
        try {
            Method m = cl.getDeclaredMethod("writeReplace", new Class[0]);
            m.setAccessible(true);
            Object replacement = m.invoke((Object)lambda, new Object[0]);
            if (replacement instanceof SerializedLambda) {
                cacheLambda = (SerializedLambda)replacement;
                LAMBDA_CACHE.put(cl, cacheLambda);
            }
        }
        catch (Exception e) {
            GLog.error("get lambda column name error", e);
            throw new HORMException("get lambda column name fail", e);
        }
        return cacheLambda;
    }
}

