/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.util;

import cn.sylinx.horm.util.GLog;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class DbKit {
    private DbKit() {
    }

    public static void closeQuietly(AutoCloseable ... aclist) {
        for (AutoCloseable ac : aclist) {
            if (ac == null) continue;
            try {
                ac.close();
            }
            catch (Exception e) {
                GLog.error("AutoCloseable close() error: ", e);
            }
        }
    }

    public static void closeQuietly(ResultSet rs, Statement st) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                GLog.error("ResultSet close() error: ", e);
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                GLog.error("Statement close() error: ", e);
            }
        }
    }

    public static void closeQuietly(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                GLog.error("Statement close() error: ", e);
            }
        }
    }
}

