/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.util;

import cn.sylinx.horm.util.GLog;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public abstract class BeanUtil {
    private static final Map<Class<?>, PropertyDescriptor[]> beanPropMap = new HashMap();
    private static final Object beanPropLock = new Object();

    private BeanUtil() {
    }

    public static Map<String, Object> bean2map(Object bean) {
        try {
            return BeanUtil.bean2mapInner(bean);
        }
        catch (Exception e) {
            GLog.error("bean2map error" + e.getMessage(), e);
            return new HashMap<String, Object>();
        }
    }

    private static Map<String, Object> bean2mapInner(Object bean) throws Exception {
        PropertyDescriptor[] pds;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (PropertyDescriptor pd : pds = BeanUtil.getBeanProperties(bean.getClass())) {
            String propertyName = pd.getName();
            Method m = pd.getReadMethod();
            Object properValue = m.invoke(bean, new Object[0]);
            map.put(propertyName, properValue);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PropertyDescriptor[] getBeanProperties(Class<?> beanClass) throws Exception {
        PropertyDescriptor[] pds = beanPropMap.get(beanClass);
        if (pds == null) {
            Object object = beanPropLock;
            synchronized (object) {
                pds = beanPropMap.get(beanClass);
                if (pds == null) {
                    BeanInfo b = Introspector.getBeanInfo(beanClass, Object.class);
                    pds = b.getPropertyDescriptors();
                    beanPropMap.put(beanClass, pds);
                }
            }
        }
        return pds;
    }
}

