/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.transaction.jdbc;

import cn.sylinx.horm.core.common.TransInfo;
import cn.sylinx.horm.core.datasource.DataSourceConnectionProvicer;
import cn.sylinx.horm.core.datasource.NamedDataSource;
import cn.sylinx.horm.core.datasource.TransactionalConnectionProvider;
import cn.sylinx.horm.exception.TransactionException;
import cn.sylinx.horm.util.GLog;
import java.sql.Connection;
import java.sql.SQLException;

public class JdbcTransactionalConnectionProvider
extends DataSourceConnectionProvicer
implements TransactionalConnectionProvider {
    private final ThreadLocal<TransInfo> transInfos = new ThreadLocal();
    private final ThreadLocal<Connection> transConnections = new ThreadLocal();

    public JdbcTransactionalConnectionProvider() {
    }

    public JdbcTransactionalConnectionProvider(NamedDataSource namedDataSource) {
        super(namedDataSource);
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.isInTransaction()) {
            Connection conn = this.transConnections.get();
            if (conn == null) {
                conn = this.getConnectionFromDataSource();
                conn.setAutoCommit(false);
                conn.setTransactionIsolation(this.transInfos.get().getTransactionIsolation());
                this.transConnections.set(conn);
            }
            return conn;
        }
        return this.getConnectionFromDataSource();
    }

    @Override
    public void releaseConnection(Connection conn) throws SQLException {
        if (this.isInTransaction()) {
            return;
        }
        if (conn != null) {
            conn.close();
        }
    }

    @Override
    public void startTransaction() {
        this.transInfos.set(new TransInfo());
    }

    @Override
    public void startTransaction(int isolationLevel) {
        this.transInfos.set(new TransInfo(isolationLevel));
    }

    @Override
    public boolean isInTransaction() {
        return this.transInfos.get() != null;
    }

    @Override
    public void commitTransaction() throws TransactionException {
        try {
            this.commitTransactionInner();
        }
        finally {
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransactionInner() {
        if (!this.isInTransaction()) {
            throw new TransactionException("CAN NOT commit transaction in non transactional env");
        }
        Connection conn = this.transConnections.get();
        if (conn == null) {
            throw new TransactionException("illegal state");
        }
        SQLException ex = null;
        try {
            conn.commit();
        }
        catch (SQLException e) {
            ex = e;
        }
        finally {
            try {
                if (!conn.isClosed()) {
                    conn.setAutoCommit(true);
                    conn.close();
                }
            }
            catch (SQLException ex1) {
                GLog.error("commit error of connection " + conn + " " + ex1.getMessage(), new Object[0]);
            }
        }
        if (ex != null) {
            throw new TransactionException(ex);
        }
    }

    @Override
    public void rollbackTransaction() {
        try {
            this.rollbackTransactionInner();
        }
        finally {
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackTransactionInner() {
        if (!this.isInTransaction()) {
            throw new TransactionException("NOT transaction");
        }
        Connection conn = this.transConnections.get();
        if (conn == null) {
            throw new TransactionException("illegal state");
        }
        SQLException e = null;
        try {
            conn.rollback();
        }
        catch (SQLException ex) {
            e = ex;
        }
        finally {
            try {
                if (!conn.isClosed()) {
                    conn.setAutoCommit(true);
                    conn.close();
                }
            }
            catch (SQLException ex) {
                GLog.error("rollback error of connection " + conn + " " + ex.getMessage(), new Object[0]);
            }
        }
        if (e != null) {
            throw new TransactionException(e);
        }
    }

    public void clear() {
        this.transConnections.remove();
        this.transInfos.remove();
    }
}

