/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.resource.parse;

import cn.sylinx.horm.resource.ClasspathSqlResourceManager;
import cn.sylinx.horm.resource.lexer.ELSEToken;
import cn.sylinx.horm.resource.lexer.ELSIFToken;
import cn.sylinx.horm.resource.lexer.ENDToken;
import cn.sylinx.horm.resource.lexer.FUNCToken;
import cn.sylinx.horm.resource.lexer.IFToken;
import cn.sylinx.horm.resource.lexer.INCToken;
import cn.sylinx.horm.resource.lexer.SqlLexer;
import cn.sylinx.horm.resource.lexer.Token;
import cn.sylinx.horm.resource.parse.ConditonBlock;
import cn.sylinx.horm.resource.parse.ELSEConditionBlock;
import cn.sylinx.horm.resource.parse.ELSIFConditionBlock;
import cn.sylinx.horm.resource.parse.ENDConditionBlock;
import cn.sylinx.horm.resource.parse.FUNCNode;
import cn.sylinx.horm.resource.parse.IFConditionBlock;
import cn.sylinx.horm.resource.parse.INCNode;
import cn.sylinx.horm.resource.parse.IfElseBlockNode;
import cn.sylinx.horm.resource.parse.OriginalContentPlaceholderParser;
import cn.sylinx.horm.resource.parse.ParsedNode;
import cn.sylinx.horm.resource.parse.PlaceholderParser;
import cn.sylinx.horm.resource.parse.SystemConditionParser;
import cn.sylinx.horm.util.CacheKeyGenerator;
import cn.sylinx.horm.util.Pair;
import com.googlecode.aviator.AviatorEvaluator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SqlLexerBasedParser {
    private static final Map<String, Pair> LEXERME_CACHE = new HashMap<String, Pair>();
    private final String sqlKey;
    private final String originalUnparsedSql;
    private String unparsedSql;
    private BitSet bitSet;

    public SqlLexerBasedParser(String sqlKey, String unparsedSql) {
        this.sqlKey = sqlKey == null ? CacheKeyGenerator.generateCacheKey(unparsedSql) : sqlKey;
        this.originalUnparsedSql = unparsedSql;
        if (!LEXERME_CACHE.containsKey(sqlKey)) {
            this.doParseLexerme();
        }
    }

    public Pair apply(Map<String, Object> params) {
        if (params == null) {
            params = new HashMap<String, Object>(8);
        }
        String sql = this.parsePlaceholderSql(params);
        String sqlReplaced = OriginalContentPlaceholderParser.INSTANCE.parseSql(sql, params);
        return this.parseSqlAndParameters(sqlReplaced, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doParseLexerme() {
        String string = this.sqlKey.intern();
        synchronized (string) {
            this.unparsedSql = this.parseIncSql(this.originalUnparsedSql);
            List<Token> lexerList = this.parseLexerScan();
            if (!lexerList.isEmpty()) {
                this.bitSet = new BitSet(lexerList.size());
            }
            LEXERME_CACHE.put(this.sqlKey, Pair.apply(this.parseLexerme(lexerList), (Object)this.unparsedSql));
        }
    }

    private List<Token> parseLexerScan() {
        ArrayList<Token> lexerList = new ArrayList<Token>();
        if (!this.unparsedSql.contains("#IF") && !this.unparsedSql.contains("#FUNC")) {
            return lexerList;
        }
        SqlLexer sqlLexer = new SqlLexer(this.unparsedSql);
        while (!sqlLexer.isEnd()) {
            Token token = sqlLexer.scan();
            if (token == null) continue;
            lexerList.add(token);
        }
        return lexerList;
    }

    private String parseIncSql(String incSql) {
        if (!incSql.contains("#INC")) {
            return incSql;
        }
        StringBuilder sb = new StringBuilder(incSql);
        SqlLexer sqlLexer = new SqlLexer(incSql);
        while (!sqlLexer.isEnd()) {
            Token token = sqlLexer.scan();
            if (!(token instanceof INCToken)) continue;
            INCToken incToken = (INCToken)token;
            String innerSql = this.parseInc(incToken);
            sb.replace(incToken.getStartIndex(), incToken.getEndIndex(), innerSql);
            return this.parseIncSql(sb.toString());
        }
        return sb.toString();
    }

    private String parseInc(INCToken incToken) {
        return ClasspathSqlResourceManager.getStatement(incToken.getContent().trim());
    }

    private List<ParsedNode> parseLexerme(List<Token> lexerList) {
        ArrayList<ParsedNode> nodeList = new ArrayList<ParsedNode>();
        if (lexerList.isEmpty()) {
            return nodeList;
        }
        for (int i = 0; i < lexerList.size(); ++i) {
            Token token = lexerList.get(i);
            Class<?> tokenClass = token.getClass();
            if (tokenClass == IFToken.class && !this.bitSet.get(i)) {
                nodeList.add(this.parseIfElseBlockNode((IFToken)token, i, lexerList));
                this.bitSet.set(i);
            }
            if (tokenClass == FUNCToken.class && !this.bitSet.get(i)) {
                nodeList.add(new FUNCNode((FUNCToken)token));
                this.bitSet.set(i);
            }
            if (tokenClass != INCToken.class || this.bitSet.get(i)) continue;
            nodeList.add(new INCNode((INCToken)token));
            this.bitSet.set(i);
        }
        return nodeList;
    }

    private IfElseBlockNode parseIfElseBlockNode(IFToken ifToken, int indexIfToken, List<Token> lexerList) {
        IfElseBlockNode ifElseBlockNode = new IfElseBlockNode();
        IFConditionBlock ifConditionBlock = new IFConditionBlock(ifToken);
        ifConditionBlock.setIfElseBlockNode(ifElseBlockNode);
        ifElseBlockNode.setIfConditionBlock(ifConditionBlock);
        ArrayList<ELSIFConditionBlock> elsifConditionBlock = new ArrayList<ELSIFConditionBlock>();
        ifElseBlockNode.setElsifConditionBlock(elsifConditionBlock);
        ConditonBlock preConditonBlock = ifConditionBlock;
        for (int i = indexIfToken + 1; i < lexerList.size(); ++i) {
            Token token = lexerList.get(i);
            Class<?> tokenClass = token.getClass();
            if (tokenClass == IFToken.class && !this.bitSet.get(i)) {
                preConditonBlock.addParsedNode(this.parseIfElseBlockNode((IFToken)token, i, lexerList));
                this.bitSet.set(i);
                continue;
            }
            if (tokenClass == ELSIFToken.class && !this.bitSet.get(i)) {
                ELSIFConditionBlock elsifCondtionBlock = new ELSIFConditionBlock((ELSIFToken)token);
                elsifCondtionBlock.setIfElseBlockNode(ifElseBlockNode);
                elsifConditionBlock.add(elsifCondtionBlock);
                this.bitSet.set(i);
                preConditonBlock = elsifCondtionBlock;
                continue;
            }
            if (tokenClass == ELSEToken.class && !this.bitSet.get(i)) {
                ELSEConditionBlock elseConditionBlock = new ELSEConditionBlock((ELSEToken)token);
                elseConditionBlock.setIfElseBlockNode(ifElseBlockNode);
                ifElseBlockNode.setElseConditionBlock(elseConditionBlock);
                this.bitSet.set(i);
                preConditonBlock = elseConditionBlock;
                continue;
            }
            if (tokenClass == ENDToken.class && !this.bitSet.get(i)) {
                ENDConditionBlock endConditionBlock = new ENDConditionBlock((ENDToken)token);
                endConditionBlock.setIfElseBlockNode(ifElseBlockNode);
                ifElseBlockNode.setEndConditionBlock(endConditionBlock);
                this.bitSet.set(i);
                break;
            }
            if (tokenClass != FUNCToken.class || this.bitSet.get(i)) continue;
            preConditonBlock.addParsedNode(new FUNCNode((FUNCToken)token));
            this.bitSet.set(i);
        }
        return ifElseBlockNode;
    }

    private Pair parseSqlAndParameters(String st, Map<String, Object> params) {
        return PlaceholderParser.INSTANCE_DEFAULT.parseSql(st, params);
    }

    private String parsePlaceholderSql(Map<String, Object> params) {
        Pair p = LEXERME_CACHE.get(this.sqlKey);
        List nodeList = (List)p.getObject(0);
        String sql = (String)p.getObject(1);
        if (nodeList.isEmpty()) {
            return sql;
        }
        this.unparsedSql = sql;
        return this.parseNodeList(nodeList, params);
    }

    private String parseNodeList(List<ParsedNode> nodeList, Map<String, Object> params) {
        int size = nodeList.size();
        StringBuilder sb = new StringBuilder();
        ParsedNode first = nodeList.get(0);
        ParsedNode lastParsedNode = nodeList.get(size - 1);
        sb.append(this.unparsedSql, 0, first.getStartIndex());
        for (int i = 0; i < size; ++i) {
            ParsedNode node = nodeList.get(i);
            if (node.getClass() == FUNCNode.class) {
                sb.append(this.parseFUNCNodeContent((FUNCNode)node, params));
            } else if (node.getClass() == IfElseBlockNode.class) {
                sb.append(this.parseIfElseBlockNodeContent((IfElseBlockNode)node, params));
            }
            int j = i + 1;
            if (j >= size) continue;
            ParsedNode next = nodeList.get(j);
            sb.append(this.unparsedSql, node.getEndIndex(), next.getStartIndex());
        }
        sb.append(this.unparsedSql.substring(lastParsedNode.getEndIndex()));
        return sb.toString();
    }

    private String parseNodeListPart(int startIndex, int endIndex, List<ParsedNode> nodeList, Map<String, Object> params) {
        int size = nodeList.size();
        StringBuilder sb = new StringBuilder();
        ParsedNode first = nodeList.get(0);
        ParsedNode lastParsedNode = nodeList.get(size - 1);
        sb.append(this.unparsedSql, startIndex, first.getStartIndex());
        for (int i = 0; i < size; ++i) {
            ParsedNode node = nodeList.get(i);
            if (node.getClass() == FUNCNode.class) {
                sb.append(this.parseFUNCNodeContent((FUNCNode)node, params));
            } else if (node.getClass() == IfElseBlockNode.class) {
                sb.append(this.parseIfElseBlockNodeContent((IfElseBlockNode)node, params));
            }
            int j = i + 1;
            if (j >= size) continue;
            ParsedNode next = nodeList.get(j);
            sb.append(this.unparsedSql, node.getEndIndex(), next.getStartIndex());
        }
        sb.append(this.unparsedSql, lastParsedNode.getEndIndex(), endIndex);
        return sb.toString();
    }

    private String parseIfElseBlockNodeContent(IfElseBlockNode ifElseBlockNode, Map<String, Object> params) {
        IFConditionBlock ifCondition = ifElseBlockNode.getIfConditionBlock();
        IFToken ifToken = ifCondition.getIfToken();
        List<ELSIFConditionBlock> elsifConditionBlockList = ifElseBlockNode.getElsifConditionBlock();
        ELSEConditionBlock elseConditionBlock = ifElseBlockNode.getElseConditionBlock();
        ENDConditionBlock endConditionBlock = ifElseBlockNode.getEndConditionBlock();
        if (endConditionBlock == null) {
            throw new RuntimeException("invalid sql");
        }
        StringBuilder sb = new StringBuilder();
        if (this.matchCondition(ifToken, params)) {
            List<ParsedNode> nodes = ifCondition.getNodes();
            int toIndex = this.getIfTokenNextIndex(ifElseBlockNode);
            if (nodes == null || nodes.isEmpty()) {
                sb.append(this.unparsedSql, ifToken.getEndIndex(), toIndex);
            } else {
                sb.append(this.parseNodeListPart(ifToken.getEndIndex(), toIndex, nodes, params));
            }
        } else {
            ELSIFConditionBlock elseifConditionBlock = this.getMatchedELSIFToken(elsifConditionBlockList, params);
            if (elseifConditionBlock != null) {
                ELSIFToken elsifToken = elseifConditionBlock.getElsifToken();
                int toIndex = this.getElsifTokenNextIndex(ifElseBlockNode, elseifConditionBlock);
                List<ParsedNode> nodes = elseifConditionBlock.getNodes();
                if (nodes == null || nodes.isEmpty()) {
                    sb.append(this.unparsedSql, elsifToken.getEndIndex(), toIndex);
                } else {
                    sb.append(this.parseNodeListPart(elsifToken.getEndIndex(), toIndex, nodes, params));
                }
            } else if (elseConditionBlock != null) {
                ELSEToken elseToken = elseConditionBlock.getElseToken();
                int toIndex = this.getElseTokenNextIndex(ifElseBlockNode);
                List<ParsedNode> nodes = elseConditionBlock.getNodes();
                if (nodes == null || nodes.isEmpty()) {
                    sb.append(this.unparsedSql, elseToken.getEndIndex(), toIndex);
                } else {
                    sb.append(this.parseNodeListPart(elseToken.getEndIndex(), toIndex, nodes, params));
                }
            }
        }
        return sb.toString();
    }

    private int getElseTokenNextIndex(IfElseBlockNode ifElseBlockNode) {
        return ifElseBlockNode.getEndConditionBlock().getEndToken().getStartIndex();
    }

    private int getElsifTokenNextIndex(IfElseBlockNode ifElseBlockNode, ELSIFConditionBlock elseifConditionBlock) {
        List<ELSIFConditionBlock> elsifConditionBlockList = ifElseBlockNode.getElsifConditionBlock();
        int targetIndex = 0;
        int size = elsifConditionBlockList.size();
        for (int i = 0; i < size; ++i) {
            if (elsifConditionBlockList.get(i) != elseifConditionBlock) continue;
            targetIndex = i + 1;
            break;
        }
        if (targetIndex < size) {
            return elsifConditionBlockList.get(targetIndex).getElsifToken().getStartIndex();
        }
        ELSEConditionBlock elseConditionBlock = ifElseBlockNode.getElseConditionBlock();
        if (elseConditionBlock != null) {
            return elseConditionBlock.getElseToken().getStartIndex();
        }
        return ifElseBlockNode.getEndConditionBlock().getEndToken().getStartIndex();
    }

    private int getIfTokenNextIndex(IfElseBlockNode ifElseBlockNode) {
        List<ELSIFConditionBlock> elsifConditionBlockList = ifElseBlockNode.getElsifConditionBlock();
        if (!elsifConditionBlockList.isEmpty()) {
            return elsifConditionBlockList.get(0).getElsifToken().getStartIndex();
        }
        ELSEConditionBlock elseConditionBlock = ifElseBlockNode.getElseConditionBlock();
        if (elseConditionBlock != null) {
            return elseConditionBlock.getElseToken().getStartIndex();
        }
        return ifElseBlockNode.getEndConditionBlock().getEndToken().getStartIndex();
    }

    private ELSIFConditionBlock getMatchedELSIFToken(List<ELSIFConditionBlock> elsifConditionBlockList, Map<String, Object> params) {
        for (ELSIFConditionBlock elsifConditionBlock : elsifConditionBlockList) {
            if (!this.matchCondition(elsifConditionBlock.getElsifToken(), params)) continue;
            return elsifConditionBlock;
        }
        return null;
    }

    private boolean matchCondition(ELSIFToken elsifToken, Map<String, Object> params) {
        return this.testCondition(elsifToken.getContent(), params);
    }

    private boolean matchCondition(IFToken ifToken, Map<String, Object> params) {
        return this.testCondition(ifToken.getContent(), params);
    }

    private boolean testCondition(String express, Map<String, Object> params) {
        return SystemConditionParser.testCondition(express, params);
    }

    private String parseFUNCNodeContent(FUNCNode funcNode, Map<String, Object> params) {
        FUNCToken funcToken = funcNode.getFuncToken();
        return this.parseFUNCContent(funcToken.getContent(), params);
    }

    private String parseFUNCContent(String express, Map<String, Object> params) {
        return (String)AviatorEvaluator.execute((String)express, params, (boolean)true);
    }
}

