/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.resource.parse;

import cn.sylinx.horm.core.common.TypedParameter;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PlaceholderParser {
    public static final PlaceholderParser INSTANCE_QM = new PlaceholderParser("?{", "}");
    public static final PlaceholderParser INSTANCE_DEFAULT = new PlaceholderParser("#{", "}");
    private String startSymbol;
    private String endSymbol;

    public PlaceholderParser(String startSymbol, String endSymbol) {
        this.startSymbol = startSymbol;
        this.endSymbol = endSymbol;
    }

    public String getStartSymbol() {
        return this.startSymbol;
    }

    public void setStartSymbol(String startSymbol) {
        this.startSymbol = startSymbol;
    }

    public String getEndSymbol() {
        return this.endSymbol;
    }

    public void setEndSymbol(String endSymbol) {
        this.endSymbol = endSymbol;
    }

    public Pair parseSql(String sql, Map<String, Object> env) {
        StringBuilder preparedStatement = new StringBuilder();
        ArrayList<Object> preparedStatementParams = new ArrayList<Object>();
        this.parseSqlInner(sql, env, preparedStatement, preparedStatementParams);
        String rst = preparedStatement.toString();
        preparedStatement = null;
        Object[] params = new Object[preparedStatementParams.size()];
        preparedStatementParams.toArray(params);
        return Pair.apply((Object)rst, (Object)params);
    }

    private void parseSqlInner(String sql, Map<String, Object> env, StringBuilder preparedStatement, List<Object> preparedStatementParams) {
        if (sql == null) {
            throw new HORMException("sql is null");
        }
        int is = sql.indexOf(this.startSymbol);
        if (is == -1) {
            preparedStatement.append(sql);
            return;
        }
        String tmp = sql.substring(is);
        int is1 = tmp.indexOf(this.endSymbol);
        int ie = is1 + is;
        if (is1 == -1) {
            throw new HORMException("illegal statement");
        }
        String split = sql.substring(is + this.startSymbol.length(), ie);
        preparedStatementParams.add(this.getTypedParameter(split, env));
        String before = sql.substring(0, is) + "?";
        preparedStatement.append(before);
        String after = sql.substring(ie + this.endSymbol.length());
        this.parseSqlInner(after, env, preparedStatement, preparedStatementParams);
    }

    private Object getTypedParameter(String key, Map<String, Object> env) {
        Object param = env.get(key);
        Object parameterTypeObject = env.get(key + "_PT");
        if (!(parameterTypeObject instanceof Class)) {
            return param;
        }
        TypedParameter typedParameter = new TypedParameter();
        typedParameter.setParameter(param);
        typedParameter.setParameterType((Class)parameterTypeObject);
        return typedParameter;
    }
}

