/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.resource.parse;

import cn.sylinx.horm.exception.HORMException;
import java.util.Map;

public final class OriginalContentPlaceholderParser {
    public static final OriginalContentPlaceholderParser INSTANCE = new OriginalContentPlaceholderParser();
    private final String startSymbol = "${";
    private final String endSymbol = "}";

    private OriginalContentPlaceholderParser() {
    }

    public String parseSql(String sql, Map<String, Object> env) {
        if (sql == null) {
            throw new HORMException("sql is null");
        }
        int is = sql.indexOf("${");
        if (is == -1) {
            return sql;
        }
        StringBuilder preparedStatement = new StringBuilder();
        this.parseSqlInner(sql, env, preparedStatement);
        return preparedStatement.toString();
    }

    private void parseSqlInner(String sql, Map<String, Object> env, StringBuilder preparedStatement) {
        int is = sql.indexOf("${");
        if (is == -1) {
            preparedStatement.append(sql);
            return;
        }
        String tmp = sql.substring(is);
        int is1 = tmp.indexOf("}");
        int ie = is1 + is;
        if (is1 == -1) {
            throw new HORMException("illegal statement");
        }
        String split = sql.substring(is + "${".length(), ie);
        String originalContent = this.getContent(split, env);
        String before = sql.substring(0, is) + originalContent;
        preparedStatement.append(before);
        String after = sql.substring(ie + "}".length());
        this.parseSqlInner(after, env, preparedStatement);
    }

    private String getContent(String key, Map<String, Object> env) {
        Object param = env.get(key);
        if (param == null) {
            return "";
        }
        return param.toString();
    }
}

