/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.resource.parse;

import cn.sylinx.horm.config.ParseSqlType;
import cn.sylinx.horm.dialect.DbType;
import cn.sylinx.horm.resource.ClasspathSqlResource;
import cn.sylinx.horm.resource.parse.AviatorSqlParser;
import cn.sylinx.horm.resource.parse.SqlParser;
import cn.sylinx.horm.resource.parse.SystemSqlParser;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.Pair;
import java.util.Map;

public class DefaultSqlParser
extends SqlParser {
    static final String SQL_POSTFIX = ".sql";
    private DbType dbtype;
    private String sqlPostfix = ".sql";
    private SqlParser sqlParserForSystem = null;
    private SqlParser sqlParserForAviator = null;

    public DefaultSqlParser() {
        this(null);
    }

    public DefaultSqlParser(DbType dbtype) {
        this(SQL_POSTFIX, dbtype);
    }

    public DefaultSqlParser(String sqlPostfix, DbType dbtype) {
        this.dbtype = dbtype;
        this.sqlParserForSystem = new SystemSqlParser(sqlPostfix, dbtype);
        this.sqlParserForAviator = new AviatorSqlParser(sqlPostfix, dbtype);
    }

    @Override
    public DbType getDbtype() {
        return this.dbtype;
    }

    @Override
    public void setDbtype(DbType dbtype) {
        this.dbtype = dbtype;
        this.sqlParserForSystem.setDbtype(dbtype);
        this.sqlParserForAviator.setDbtype(dbtype);
    }

    @Override
    public String getSqlPostfix() {
        return this.sqlPostfix;
    }

    @Override
    public void setSqlPostfix(String sqlPostfix) {
        this.sqlPostfix = sqlPostfix;
        this.sqlParserForSystem.setSqlPostfix(sqlPostfix);
        this.sqlParserForAviator.setSqlPostfix(sqlPostfix);
    }

    @Override
    public Pair parseSql(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Pair p = null;
        String type = sqlResource.getType();
        if (ParseSqlType.AVIATOR.getType().equals(type)) {
            p = this.sqlParserForAviator.parseSql(sqlResource, params);
        } else if (ParseSqlType.SYSTEM.getType().equals(type)) {
            p = this.sqlParserForSystem.parseSql(sqlResource, params);
        }
        GLog.debug("parseSql -> {}", p);
        return p;
    }

    @Override
    public Pair parseSql(String statement, String type, Map<String, Object> params) {
        if (ParseSqlType.AVIATOR.getType().equals(type)) {
            return this.sqlParserForAviator.parseSql(statement, type, params);
        }
        if (ParseSqlType.SYSTEM.getType().equals(type)) {
            return this.sqlParserForSystem.parseSql(statement, type, params);
        }
        return null;
    }

    @Override
    public String parseSqlPart(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        String type = sqlResource.getType();
        if (ParseSqlType.AVIATOR.getType().equals(type)) {
            return this.sqlParserForAviator.parseSqlPart(sqlResource, params);
        }
        if (ParseSqlType.SYSTEM.getType().equals(type)) {
            return this.sqlParserForSystem.parseSqlPart(sqlResource, params);
        }
        return null;
    }

    @Override
    public String parseSqlPart(String statement, String type, Map<String, Object> params) {
        if (ParseSqlType.AVIATOR.getType().equals(type)) {
            return this.sqlParserForAviator.parseSqlPart(statement, type, params);
        }
        if (ParseSqlType.SYSTEM.getType().equals(type)) {
            return this.sqlParserForSystem.parseSqlPart(statement, type, params);
        }
        return null;
    }
}

