/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.resource.parse;

import cn.sylinx.horm.dialect.DbType;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.resource.ClasspathSqlResource;
import cn.sylinx.horm.resource.ClasspathSqlResourceManager;
import cn.sylinx.horm.resource.parse.PlaceholderParser;
import cn.sylinx.horm.resource.parse.SqlParser;
import cn.sylinx.horm.util.CacheKeyGenerator;
import cn.sylinx.horm.util.Pair;
import cn.sylinx.horm.util.StrKit;
import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import java.util.Map;

class AviatorSqlParser
extends SqlParser {
    private DbType dbtype;
    private String sqlPostfix;

    public AviatorSqlParser(String sqlPostfix, DbType dbtype) {
        this.sqlPostfix = sqlPostfix;
        this.dbtype = dbtype;
    }

    @Override
    public DbType getDbtype() {
        return this.dbtype;
    }

    @Override
    public void setDbtype(DbType dbtype) {
        this.dbtype = dbtype;
    }

    @Override
    public String getSqlPostfix() {
        return this.sqlPostfix;
    }

    @Override
    public void setSqlPostfix(String sqlPostfix) {
        this.sqlPostfix = sqlPostfix;
    }

    @Override
    public Pair parseSql(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        String statement = this.getStatement(sqlResource.getSqlpath());
        return this.parseSqlUseKey(sqlResource.getSqlpath(), statement, params);
    }

    @Override
    public String parseSqlPart(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        String statement = this.getStatement(sqlResource.getSqlpath());
        return this.parseSqlPartUseKey(sqlResource.getSqlpath(), statement, params);
    }

    protected String getStatement(String sqlpath) {
        String truelySqlPath = this.parseTruelySqlpath(sqlpath);
        String statement = ClasspathSqlResourceManager.getStatement(truelySqlPath);
        if (StrKit.isBlank(statement)) {
            throw new HORMException("SQL\u8bed\u53e5\u4e3a\u7a7a, \u8d44\u6e90:" + truelySqlPath);
        }
        return statement;
    }

    protected String getRealSqlPostfix() {
        return "_" + this.dbtype.getValue() + this.sqlPostfix;
    }

    protected String parseTruelySqlpath(String sqlpath) {
        if (this.dbtype == null) {
            return sqlpath;
        }
        String dbtypePostfix = this.getRealSqlPostfix();
        boolean endsWithDbtypePostfix = sqlpath.endsWith(dbtypePostfix);
        if (endsWithDbtypePostfix) {
            return sqlpath;
        }
        int index = sqlpath.lastIndexOf(this.sqlPostfix);
        if (index < 1) {
            throw new HORMException("invalid sql resource file");
        }
        return sqlpath.substring(0, index) + dbtypePostfix;
    }

    private Pair parseSqlUseKey(String sqlKey, String statement, Map<String, Object> params) {
        String cacheKey = sqlKey == null ? CacheKeyGenerator.generateCacheKey(statement) : sqlKey;
        Expression exp = AviatorEvaluator.compile((String)cacheKey, (String)statement, (boolean)true);
        Object ret = exp.execute(params);
        if (ret instanceof Pair) {
            return (Pair)ret;
        }
        return PlaceholderParser.INSTANCE_QM.parseSql(ret.toString(), params);
    }

    @Override
    public Pair parseSql(String statement, String type, Map<String, Object> params) {
        return this.parseSqlUseKey(null, statement, params);
    }

    private String parseSqlPartUseKey(String sqlKey, String statement, Map<String, Object> params) {
        String cacheKey = sqlKey == null ? CacheKeyGenerator.generateCacheKey(statement) : sqlKey;
        Expression exp = AviatorEvaluator.compile((String)cacheKey, (String)statement, (boolean)true);
        Object ret = exp.execute(params);
        return ret.toString();
    }

    @Override
    public String parseSqlPart(String statement, String type, Map<String, Object> params) {
        return this.parseSqlPartUseKey(null, statement, params);
    }
}

