/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.resource.lexer;

import cn.sylinx.horm.resource.lexer.Keyword;
import cn.sylinx.horm.resource.lexer.KeywordToken;
import cn.sylinx.horm.resource.lexer.Token;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

public class SqlLexer {
    private static final char ESCAPE_SYMBOL = '\\';
    private static final char SQUARE_BRACKET_RIGHT = ']';
    private static final char SQUARE_BRACKET_LEFT = '[';
    private static final char C_BLANK = ' ';
    private static final char ES_T = '\t';
    private static final char ES_R = '\r';
    private static final char ES_N = '\n';
    private static final char KEYWORD_BEGIN = '#';
    private final String unparsedSql;
    private final CharacterIterator iterator;
    private char peek;
    private int lineNo;

    public SqlLexer(String unparsedSql) {
        this.iterator = new StringCharacterIterator(unparsedSql);
        this.unparsedSql = unparsedSql;
        this.peek = this.iterator.current();
        this.lineNo = 1;
    }

    public Token scan() {
        while (true) {
            if (this.isEnd()) {
                return null;
            }
            if (this.peek != ' ' && this.peek != '\t' && this.peek != '\r' && this.peek != '\n') break;
            if (this.peek == '\n') {
                ++this.lineNo;
            }
            this.nextChar();
        }
        if (this.peek == '#') {
            int startIndex = this.iterator.getIndex();
            this.nextChar();
            StringBuilder sb = new StringBuilder();
            sb.append('#').append(this.peek);
            do {
                String content;
                if (this.hitKeyword(content = sb.toString())) {
                    this.nextChar();
                    if (this.needSquareBracketContent(content)) {
                        if (this.peek != '[') {
                            return this.scan();
                        }
                        String squareBracketContent = this.parseSquareBracketContent();
                        KeywordToken token = Keyword.create(content, this.lineNo, startIndex, this.iterator.getIndex());
                        token.setContent(squareBracketContent);
                        return token;
                    }
                    if (this.peek == ' ' || this.peek == '\t' || this.peek == '\r' || this.peek == '\n' || this.isEnd()) {
                        return Keyword.create(content, this.lineNo, startIndex, this.iterator.getIndex());
                    }
                    return this.scan();
                }
                this.nextChar();
                sb.append(this.peek);
            } while (this.isSeeminglyKeyword(sb.toString()));
        }
        this.nextChar();
        return this.scan();
    }

    private String parseSquareBracketContent() {
        StringBuilder sb = new StringBuilder();
        this.nextChar();
        boolean closed = false;
        while (!this.isEnd()) {
            if (this.isEscapeSymbol()) {
                this.nextChar();
                if (this.isSquareBracketsRight()) {
                    sb.append(']');
                } else {
                    sb.append('\\').append(this.peek);
                }
            } else {
                if (this.isSquareBracketsRight()) {
                    this.nextChar();
                    closed = true;
                    break;
                }
                sb.append(this.peek);
            }
            this.nextChar();
        }
        if (!closed) {
            throw new RuntimeException("invalid condtion, right square bracket missed");
        }
        String r = sb.toString();
        if (r.trim().isEmpty()) {
            throw new RuntimeException("empty condition");
        }
        return sb.toString();
    }

    private boolean isSquareBracketsRight() {
        return this.peek == ']';
    }

    private boolean isEscapeSymbol() {
        return this.peek == '\\';
    }

    public boolean isEnd() {
        return this.peek == '\uffff';
    }

    private boolean needSquareBracketContent(String key) {
        return Keyword.needSquareBracketContent(key);
    }

    private boolean hitKeyword(String key) {
        return Keyword.hitKeyword(key);
    }

    private boolean isSeeminglyKeyword(String kw) {
        return Keyword.isSeeminglyKeyword(kw);
    }

    private void nextChar() {
        this.peek = this.iterator.next();
    }

    public char getPeek() {
        return this.peek;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public String getUnparsedSql() {
        return this.unparsedSql;
    }

    public static void main(String[] args) {
        String unparsedSql = "#IF[a > 0] aaaa #ELSE bbb #{testField} #FUNC[a,xx,bb] #END";
        SqlLexer sqlLexer = new SqlLexer(unparsedSql);
        while (!sqlLexer.isEnd()) {
            Token token = sqlLexer.scan();
            System.out.println(token);
            System.out.println(unparsedSql.substring(token.getStartIndex(), token.getEndIndex()));
        }
    }
}

