/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.resource.lexer;

import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.resource.lexer.ELSEToken;
import cn.sylinx.horm.resource.lexer.ELSIFToken;
import cn.sylinx.horm.resource.lexer.ENDToken;
import cn.sylinx.horm.resource.lexer.FUNCToken;
import cn.sylinx.horm.resource.lexer.IFToken;
import cn.sylinx.horm.resource.lexer.INCToken;
import cn.sylinx.horm.resource.lexer.KeywordToken;
import java.util.HashSet;

public abstract class Keyword {
    public static final String KW_IF = "#IF";
    public static final String KW_ELSIF = "#ELSIF";
    public static final String KW_ELSE = "#ELSE";
    public static final String KW_END = "#END";
    public static final String KW_FUNC = "#FUNC";
    public static final String KW_INC = "#INC";
    private static final HashSet<String> KEYWORDS = new HashSet();
    private static final HashSet<String> KEYWORDS_NEED_SQUARE_BRACKET_CONTENT = new HashSet();

    private Keyword() {
    }

    static boolean needSquareBracketContent(String key) {
        return KEYWORDS_NEED_SQUARE_BRACKET_CONTENT.contains(key);
    }

    static boolean hitKeyword(String key) {
        return KEYWORDS.contains(key);
    }

    static boolean isSeeminglyKeyword(String kw) {
        return KW_IF.startsWith(kw) || KW_ELSIF.startsWith(kw) || KW_ELSE.startsWith(kw) || KW_END.startsWith(kw) || KW_FUNC.startsWith(kw) || KW_INC.startsWith(kw);
    }

    public static KeywordToken create(String keyword, int lineNo, int startIndex, int endIndex) {
        if (KW_IF.equals(keyword)) {
            return new IFToken(lineNo, startIndex, endIndex);
        }
        if (KW_ELSIF.equals(keyword)) {
            return new ELSIFToken(lineNo, startIndex, endIndex);
        }
        if (KW_ELSE.equals(keyword)) {
            return new ELSEToken(lineNo, startIndex, endIndex);
        }
        if (KW_END.equals(keyword)) {
            return new ENDToken(lineNo, startIndex, endIndex);
        }
        if (KW_FUNC.equals(keyword)) {
            return new FUNCToken(lineNo, startIndex, endIndex);
        }
        if (KW_INC.equals(keyword)) {
            return new INCToken(lineNo, startIndex, endIndex);
        }
        throw new HORMException("invalid keyword: " + keyword);
    }

    static {
        KEYWORDS.add(KW_IF);
        KEYWORDS.add(KW_ELSIF);
        KEYWORDS.add(KW_ELSE);
        KEYWORDS.add(KW_END);
        KEYWORDS.add(KW_FUNC);
        KEYWORDS.add(KW_INC);
        KEYWORDS_NEED_SQUARE_BRACKET_CONTENT.add(KW_IF);
        KEYWORDS_NEED_SQUARE_BRACKET_CONTENT.add(KW_ELSIF);
        KEYWORDS_NEED_SQUARE_BRACKET_CONTENT.add(KW_FUNC);
        KEYWORDS_NEED_SQUARE_BRACKET_CONTENT.add(KW_INC);
    }
}

