/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.resource.io;

import cn.sylinx.horm.resource.io.BaseResourceScanner;
import cn.sylinx.horm.resource.io.ClassFilter;
import cn.sylinx.horm.resource.io.Resources;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;

public class ClassScanner
extends BaseResourceScanner {
    private final ClassFilter classFilter;

    public static Set<Class<?>> scanAllPackageByAnnotation(String packageName, Class<? extends Annotation> annotationClass) {
        return ClassScanner.scanAllPackage(packageName, clazz -> clazz.isAnnotationPresent(annotationClass));
    }

    public static Set<Class<?>> scanPackageByAnnotation(String packageName, Class<? extends Annotation> annotationClass) {
        return ClassScanner.scanPackage(packageName, clazz -> clazz.isAnnotationPresent(annotationClass));
    }

    public static Set<Class<?>> scanAllPackageBySuper(String packageName, Class<?> superClass) {
        return ClassScanner.scanAllPackage(packageName, clazz -> superClass.isAssignableFrom(clazz) && !superClass.equals(clazz));
    }

    public static Set<Class<?>> scanPackageBySuper(String packageName, Class<?> superClass) {
        return ClassScanner.scanPackage(packageName, clazz -> superClass.isAssignableFrom(clazz) && !superClass.equals(clazz));
    }

    public static Set<Class<?>> scanAllPackage() {
        return ClassScanner.scanAllPackage("", null);
    }

    public static Set<Class<?>> scanPackage() {
        return ClassScanner.scanPackage("", null);
    }

    public static Set<Class<?>> scanPackage(String packageName) {
        return ClassScanner.scanPackage(packageName, null);
    }

    public static Set<Class<?>> scanAllPackage(String packageName, ClassFilter classFilter) {
        Set<Object> sets = new ClassScanner(packageName, classFilter).scan(true);
        HashSet classSets = new HashSet();
        sets.forEach(c -> classSets.add((Class)c));
        return classSets;
    }

    public static Set<Class<?>> scanPackage(String packageName, ClassFilter classFilter) {
        Set<Object> sets = new ClassScanner(packageName, classFilter).scan();
        HashSet classSets = new HashSet();
        sets.forEach(c -> classSets.add((Class)c));
        return classSets;
    }

    public ClassScanner() {
        this(null);
    }

    public ClassScanner(String packageName) {
        this(packageName, null);
    }

    public ClassScanner(String packageName, ClassFilter classFilter) {
        super(packageName);
        this.classFilter = classFilter;
    }

    @Override
    protected String getMatchedPostfix() {
        return ".class";
    }

    @Override
    protected boolean accept(String resoureName) {
        Class<?> clazz = this.loadClass(resoureName);
        if (null != clazz) {
            return this.classFilter == null || this.classFilter.accept(clazz);
        }
        return false;
    }

    @Override
    protected Object transform(String resoureName) {
        return this.loadClass(resoureName);
    }

    private Class<?> loadClass(String className) {
        ClassLoader loader = Resources.getClassLoader();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, false, loader);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return clazz;
    }
}

