/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.resource.func.aviator;

import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.resource.func.aviator.AviatorFunctionConsts;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorString;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class ForeachAviatorFunction
extends AbstractFunction {
    public String getName() {
        return "foreach";
    }

    public AviatorObject call(Map<String, Object> env, AviatorObject argKey, AviatorObject openSymbol, AviatorObject splitSymbol, AviatorObject closeSymbol, AviatorObject quoteSymbol) {
        Object obj = FunctionUtils.getJavaObject((AviatorObject)argKey, env);
        if (obj == null) {
            return AviatorFunctionConsts.EMPTY;
        }
        if (!(obj instanceof Collection)) {
            throw new HORMException("invalid arguments");
        }
        Collection collections = (Collection)obj;
        if (collections.isEmpty()) {
            return AviatorFunctionConsts.EMPTY;
        }
        String openSymbolStr = FunctionUtils.getStringValue((AviatorObject)openSymbol, env);
        String splitSymbolStr = FunctionUtils.getStringValue((AviatorObject)splitSymbol, env);
        String closeSymbolStr = FunctionUtils.getStringValue((AviatorObject)closeSymbol, env);
        String quote = FunctionUtils.getStringValue((AviatorObject)quoteSymbol, env);
        Iterator it = collections.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append(openSymbolStr);
        while (it.hasNext()) {
            sb.append(quote).append(it.next().toString()).append(quote).append(splitSymbolStr);
        }
        int splitLen = splitSymbolStr.length();
        int totalLen = sb.length();
        sb.delete(totalLen - splitLen, totalLen);
        sb.append(closeSymbolStr);
        return new AviatorString(sb.toString());
    }
}

