/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.resource;

import cn.sylinx.horm.config.OrmConfigHolder;
import cn.sylinx.horm.resource.io.Resources;
import cn.sylinx.horm.util.GLog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public final class ClasspathSqlResourceManager
extends Enum<ClasspathSqlResourceManager> {
    private static final Map<String, String> cache;
    private static final /* synthetic */ ClasspathSqlResourceManager[] $VALUES;

    public static ClasspathSqlResourceManager[] values() {
        return (ClasspathSqlResourceManager[])$VALUES.clone();
    }

    public static ClasspathSqlResourceManager valueOf(String name) {
        return Enum.valueOf(ClasspathSqlResourceManager.class, name);
    }

    public static void clear() {
        cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String get(String sqlpath) {
        InputStream is = null;
        ByteArrayOutputStream baos = null;
        String statement = null;
        try {
            is = Resources.getResourceAsStream(sqlpath);
            baos = new ByteArrayOutputStream();
            int i = -1;
            while ((i = is.read()) != -1) {
                baos.write(i);
            }
            statement = baos.toString();
        }
        catch (Exception e) {
            GLog.error("sql resource \"" + sqlpath + "\" not found " + e.getMessage(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return statement;
    }

    public static void load(String sqlpath) {
        String statement = ClasspathSqlResourceManager.get(sqlpath);
        if (statement != null) {
            cache.put(sqlpath, statement);
        }
    }

    private static String loadAndGet(String sqlpath) {
        ClasspathSqlResourceManager.load(sqlpath);
        return cache.get(sqlpath);
    }

    public static String getStatement(String sqlpath) {
        if (OrmConfigHolder.isDebug()) {
            return ClasspathSqlResourceManager.get(sqlpath);
        }
        if (cache.containsKey(sqlpath)) {
            GLog.debug("sql bingo: {}", sqlpath);
            return cache.get(sqlpath);
        }
        return ClasspathSqlResourceManager.loadAndGet(sqlpath);
    }

    private static /* synthetic */ ClasspathSqlResourceManager[] $values() {
        return new ClasspathSqlResourceManager[0];
    }

    static {
        $VALUES = ClasspathSqlResourceManager.$values();
        cache = new HashMap<String, String>();
    }
}

