/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.resource;

import cn.sylinx.horm.config.OrmConfigHolder;
import cn.sylinx.horm.config.ParseSqlType;
import cn.sylinx.horm.resource.SqlResourceType;

public class ClasspathSqlResource {
    private String sqlpath;
    private boolean format = true;
    private String type;

    public static ClasspathSqlResource applySystemResource(String sqlPath) {
        return ClasspathSqlResource.apply(sqlPath, ParseSqlType.SYSTEM.getType());
    }

    public static ClasspathSqlResource applyAviatorResource(String sqlPath) {
        return ClasspathSqlResource.apply(sqlPath, ParseSqlType.AVIATOR.getType());
    }

    public static ClasspathSqlResource apply(String sqlPath) {
        return ClasspathSqlResource.apply(sqlPath, OrmConfigHolder.getParseSqlType());
    }

    public static ClasspathSqlResource apply(String sqlPath, String type) {
        return new ClasspathSqlResource(sqlPath, type);
    }

    public ClasspathSqlResource() {
    }

    public ClasspathSqlResource(String sqlpath) {
        this(sqlpath, OrmConfigHolder.getParseSqlType());
    }

    public ClasspathSqlResource(String sqlpath, String type) {
        this.sqlpath = sqlpath;
        this.type = type;
    }

    public SqlResourceType getSqlResourceType() {
        return SqlResourceType.CLASSPATHSQL;
    }

    public String getSqlResource() {
        return this.getSqlpath();
    }

    public String getSqlpath() {
        return this.sqlpath;
    }

    public void setSqlpath(String sqlpath) {
        this.sqlpath = sqlpath;
    }

    public boolean isFormat() {
        return this.format;
    }

    public void setFormat(boolean format) {
        this.format = format;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

